package algoprog.base;

/**
 * Une classe pour des files dynamiques. Une file dynamique est une file dont
 * on ne connat pas  l'avance le nombre maximum d'lments ajoutables
 * conscutivement. Le nombre d'lments contenus dans la file  un instant
 * donn est la longueur de la file.
 * Sauf mention contraire, toutes les mthodes sont en O(1).
 * (voir le <a href="../../../html/asd/base/FileDynamique.html">source</a>).
 * @author  2002 Marc Gatano
 * @version 3.0 (23/09/03)
 */
public class FileDynamique {

    private ListeSimple entree; // o on ajoute les entrant
    private ListeSimple sortie; // o on retire les sortant
    private int longueur;

    /**
     * Construit une file vide.
     */
    public FileDynamique() {
        entree = null;
        sortie = null;
        longueur = 0;
    }

    /**
     * Ajoute un nouvel objet dans la file.
     */
    public void ajouter(Object objet) {
        if ( vide() ) {
            entree = new ListeSimple(objet);
            sortie = entree;
        }
        else {
            entree.reste = new ListeSimple(objet);
            entree = entree.reste;
        }
        longueur++;
    }

    /**
     * Retire un objet de la file et retourne cet objet.
     * Prcondition : la file n'est pas vide.
     */
    public Object retirer() {
        Object x = sortie.premier;
        sortie = sortie.reste;
        if ( sortie == null ) {
            entree = null;
        }
        longueur--;
        return x;
    }

    /**
     * Retourne l'objet situ en tte de la file.
     * Prcondition : la file n'est pas vide.
     */
    public Object suivant() {
        return sortie.premier;
    }

    /**
     * Retourne le nombre d'lments contenus dans la file.
     */
    public int longueur() {
        return longueur;
    }

    /**
     * Teste si la file est vide.
     */
    public boolean vide() {
        return entree == null;
    }

    /**
     * Teste si la file est pleine.
     */
    public boolean pleine() {
        return false;
    }

    /**
     * Retourne une reprsentation de la file.
     * Complexit : O(longueur()).
     */
    public String toString() {
        String s = "<- ";
        ListeSimple l = sortie;
        while ( l != null ) {
            s = s + l.premier + ' ';
            l = l.reste;
        }
        return s + "<-";
    }
}
