package algoprog.base;

/**
 * Une classe pour les listes simples. Une liste est une suite de cellules
 *  deux cases, la premiere case contenant une valeur (de type Object)
 * et la deuxime case contenant une liste, la suite de la liste. Pour
 * exister, la liste vide doit tre constitue d'au moins une cellule. Une
 * liste  n lments est donc constitue de n + 1 cellules, la dernire
 * reprsentant la liste vide.
 * Sauf mention contraire, toutes les mthodes sont en O(1).
 * (voir le <a href="../../../html/asd/base/Liste.html">source</a>).
 * @author  2001 Marc Gatano
 * @version 1.0 (05/11/01)
 */
public class Liste {

    private Object premier; // la valeur de la cellule
    private Liste  reste;   // la suite du chanage

    // Constructeurs

    /**
     * Construit une liste vide.
     */
    public Liste() {
        this.premier = null;
        this.reste   = null;
    }

    /**
     * Construit une liste  un lment, l'objet x.
     */
    public Liste(Object x) {
        this(x,new Liste());
    }

    /**
     * Construit une liste dont le premier lment est l'objet x
     * et dont la suite est la liste l.
     */
    public Liste(Object x, Liste l) {
        this.premier = x;
        this.reste   = l;
    }

    // PRIMITIVES

    /**
     * Retourne le premier lment de la liste.
     */
    public Object premier() {
        return premier;
    }

    /**
     * Retourne le reste de la liste, c'est  dire la liste initiale
     * sans son premier lment.
     */
    public Liste reste() {
        return reste;
    }

    /**
     * Ajoute l'objet x en tte de la liste.
     */
    public void ajouter(Object x) {
        reste   = new Liste(premier,reste);
        premier = x;
    }

    /**
     * Supprime l'lment en tte de la liste.
     * Prcondition : la liste n'est pas vide.
     */
    public void supprimer() {
        premier = reste.premier;
        reste   = reste.reste;
    }
    
    /**
     * Teste si la liste est vide.
     */
    public boolean vide() {
        return reste == null;
    }

    // NON-PRIMITIVES  CRIRE  l'AIDE DES PRIMITIVES

    /**
     * Retourne une chane de caractres reprsentant la liste.
     * Complexit : O(n) o n est le nombre d'lments de la liste.
     */
    public String toString() {
        if ( vide() ) {
            return "->";
        }
        String s = "-> " + premier();
        Liste l = reste();
        while ( ! l.vide() ) {
            s = s + " -> " + l.premier();
            l = l.reste();
        } 
        return s;
    }
}
