package algoprog.base;

import java.lang.Comparable;

/**
 * Une classe pour des objets constitus d'une information (un Object)
 * et d'une clef (un int). Toutes les mthodes sont en O(1).
 * (voir le <a href="../../../html/asd/base/ObjetAClef.html">source</a>).
 * @author  2002 Marc Gatano
 * @version 3.0 (26/09/02)
 */
public class ObjetAClef implements Comparable<ObjetAClef> {

    private Object info; // l'information associe  la clef
    private int clef;    // la clef de l'objet

    /**
     * Construit un ObjetAClef avec info et clef.
     */
    public ObjetAClef(Object info, int clef) {
        this.info  = info;
        this.clef = clef;
    }

    /**
     * Construit un ObjetAClef sans info avec clef.
     */
    public ObjetAClef(int clef) {
        this.info = null;
        this.clef = clef;
    }

    /**
     * Retourne l'information contenue dans l'ObjetAClef.
     */
    public Object info() {
        return info;
    }

    /**
     * Retourne la clef de l'ObjetAClef.
     */
    public int clef() {
        return clef;
    }

    /**
     * Compare  l'objet <code>o</code>.
     * @param o Un ObjetAClef.
     * @return this.clef() - o.clef().
     */
    public int compareTo (ObjetAClef o) {
        return this.clef() - o.clef();
    }

    /**
     * Retourne la reprsentation d'un ObjetAClef sous forme d'une chane
     * de caractres.
     */
    public String toString() {
        if ( info == null )
            return "[" + clef + "]";
        return "[" + clef + "," + info + "]";
    }
}
