package algoprog.base;

/**
 * Une classe pour des piles dynamiques. Une pile dynamique est une pile
 * implmente  l'aide d'une liste chane. Dans une pile dynamique, on
 * a pas besoin de connatre  l'avance le nombre maximum d'lments
 * empilables conscutivement. Une pile dynamique n'est virtuellement
 * jamais pleine.
 * Sauf mention contraire, toutes les mthodes sont en O(1).
 * (voir le <a href="../../../html/asd/base/PileDynamique.html">source</a>).
 * @author  2002 Marc Gatano
 * @version 3.0 (23/09/02)
 */
public class PileDynamique {

    private ListeSimple sommet; // le sommet de la pile
    private int hauteur;        // la hauteur de la pile

    /**
     * Construit une pile vide.
     */
    public PileDynamique() {
        sommet = null;
        hauteur = 0;
    }

    /**
     * Empile un nouvel objet dans la pile.
     * Prcondition : la pile n'est pas pleine.
     */
    public void empiler(Object objet) {
        sommet = new ListeSimple(objet,sommet);
        hauteur++;
    }

    /**
     * Dpile un nouvel objet dans la pile.
     * Prcondition : la pile n'est pas vide.
     */
    public Object depiler() {
        Object tmp = sommet.premier;
        sommet = sommet.reste;
        hauteur--;
        return tmp;
    }
    
    /**
     * Retourne l'objet situ en sommet de pile.
     * Prcondition : la pile n'est pas vide.
     */
    public Object sommet() {
        return sommet.premier;
    }

    /**
     * Retourne le nombre d'lments contenus dans la pile.
     */
    public int hauteur() {
        return hauteur;
    }

    /**
     * Teste si la pile est vide.
     */
    public boolean vide() {
        return sommet == null;
    }

    /**
     * Teste si la pile est pleine.
     */
    public boolean pleine() {
        return false;
    }

    /**
     * Retourne une reprsentation de la pile.
     * Complexit : O(hauteur()).
     */
    public String toString() {
        String s = " <- SOMMET";
        ListeSimple l = sommet;
        while ( l != null ) {
            s = " " + l.premier + s;
            l = l.reste;
        }
        return "[" + s;
    }
}
