package algoprog.base;

/**
 * Une classe pour des piles statiques. Une pile statique est une pile dont
 * on connat  l'avance le nombre maximum d'lments empilables
 * conscutivement. Ce nombre s'appelle la taille de la pile. Quand la pile
 * contient un nombre d'objets gal  sa taille, on dit qu'elle est pleine.
 * Sauf mention contraire, toutes les mthodes sont en O(1).
 * (voir le <a href="../../../html/asd/base/PileStatique.html">source</a>).
 * @author  2002 Marc Gatano
 * @version 3.0 (23/09/02)
 */
public class PileStatique {

    private Object[] table; // le tableau contenant les lments de pile
    private int n;          // table[0..n-1] sont les lments significatifs
                            // de la pile

    /**
     * Construit une pile vide de taille maximum une valeur par dfaut.
     */
    public PileStatique() {
        this(64);
    }

    /**
     * Construit une pile vide de taille donne.
     * Paramtre taille : la taille de la pile.
     */
    public PileStatique(int taille) {
	table = new Object[taille];
	n = 0;
    }
    
    /**
     * Empile un nouvel objet dans la pile.
     * Prcondition : la pile n'est pas pleine.
     */
    public void empiler(Object x) {
	table[n] = x;
	n++;
    }
    
    /**
     * Retourne l'objet situ en sommet de pile
     * et dpile cet objet de la pile.
     * Prcondition : la pile n'est pas vide.
     */
    public Object depiler() {
	n--;
	return table[n];
    }

    /**
     * Retourne l'objet situ en sommet de pile.
     * Prcondition : la pile n'est pas vide.
     */
    public Object sommet() {
	return table[n-1];
    }

    /**
     * Retourne le nombre d'lments contenus dans la pile.
     */
    public int hauteur() {
	return n;
    }

    /**
     * Teste si la pile est vide.
     */
    public boolean vide() {
	return n == 0;
    }

    /**
     * Teste si la pile est pleine.
     */
    public boolean pleine() {
	return n == table.length;
    }

    /**
     * Retourne une copie de la pile.
     * Complexit : O(hauteur()).
     */
    public Object clone() {
	PileStatique p = new PileStatique(table.length);

	p.n = n;
	
	for ( int i = 0; i < n; i++ ) {
	    p.table[i] = table[i];
	}

	return p;
    }

    /**
     * Retourne une reprsentation de la pile.
     * Complexit : O(hauteur()).
     */
    public String toString() {
	String s = "[";

	for ( int i = 0; i < n; i++ ) {
	    s = s + " " + table[i];
	}

	return s + " <- SOMMET ]";
    }
}
