package algoprog.base.util;

import algoprog.base.ObjetAClef;

/**
 * Une classe pour gnrer des objets alatoirement.
 * (voir le <a href="../../../html/asd/util/Hasard.html">source</a>).
 * @author  2000 Marc Gatano
 * @version 1.0 (6/11/00)
 */
public class Hasard {

    private java.util.Random r;
    private char[] v = new char[6];
    private char[] c = new char[20];

    /**
     * Construit un objet Hasard pour la gnration alatoire
     * d'objets de types divers.
     */
    public Hasard() {
        r = new java.util.Random();

        v[0] = 'a'; v[1] = 'e'; v[2] = 'i'; v[3] = 'o'; v[4] = 'u'; v[5] = 'y';

        c[0] = 'b'; c[1] = 'c'; c[2] = 'd'; c[3] = 'f'; c[4] = 'g';
        c[5] = 'h'; c[6] = 'j'; c[7] = 'k'; c[8] = 'l'; c[9] = 'm';        
        c[10] = 'n'; c[11] = 'p'; c[12] = 'q'; c[13] = 'r'; c[14] = 's';
        c[15] = 't'; c[16] = 'v'; c[17] = 'w'; c[18] = 'x'; c[19] = 'z';
    }

    /**
     * Gnre alatoirement un entier positif ou nul.
     */
    public int entier() {
        int n = r.nextInt();
        if ( n < 0 ) {
            return - n;
        }
        return n;
    }

    /**
     * Gnre alatoirement un entier compris entre 0 et n - 1.
     */
    public int entier(int n) {
        return r.nextInt(n);
    }

    /**
     * Gnre alatoirement une String de n caractres.
     */
    public String chaine(int n) {
        String s = new String();
        boolean voyelle = false;
        for ( int i = 0; i < n; i++ ) {
            if ( voyelle ) {
                s = s + v[entier() % 6];
            }
            else {
                s = s + c[entier() % 20];
            }
            voyelle = ! voyelle;
        }
        return s;
    }

    /**
     * Gnre alatoirement un ObjetAClef dont le nom est une String
     * contenant n caractres et dont la clef est un entier compris
     * entre 0 et c - 1. 
     */
    public ObjetAClef objetAClef(int n, int c) {
        return new ObjetAClef(chaine(n),entier(c));
    }

    /**
     * Gnre alatoirement un tableau d'int contenant n lments.
     */
    public int[] tableauInt(int n) {
        int[] t = new int[n];
        for ( int i = 0; i < t.length; i++ ) {
            t[i] = entier();
        }
        return t;
    }

    /**
     * Gnre alatoirement un tableau d'int contenant n lments
     * tous compris entre 0 et m - 1.
     */
    public int[] tableauInt(int n, int m) {
        int[] t = new int[n];
        for ( int i = 0; i < t.length; i++ ) {
            t[i] = entier(m);
        }
        return t;
    }

    /**
     * Gnre alatoirement un Tableau de ObjetAClef contenant m lments,
     * chaque ObjetAClef tant form d'une String contenant n caractres et
     * d'une clef qui est un entier compris entre 0 et c - 1.
     */
    public ObjetAClef[] tableauObjetAClef(int m, int n, int c) {
        ObjetAClef[] t = new ObjetAClef[m];
        for ( int i = 0; i < t.length; i++ ) {
            t[i] = objetAClef(n,c);
        }
        return t;
    }
}
