package algoprog.util;



import java.io.*;
import java.util.*;

import algoprog.base.ObjetAClef;
import algoprog.base.util.Hasard;

/**
 * Une classe pour la saisie d'objets de types divers. Aucune mthode
 * ne lve d'exception.
 * Note : Cette classe est diffrente de la classe ccj.Console.
 * (voir le <a href="../../../html/asd/util/Console.html">source</a>).
 * @author  1999 Marc Gatano
 * @version 1.0 (21/10/99)
 */
public class Console {

    private static BufferedReader in = // le buffer
	new BufferedReader(new InputStreamReader(System.in),64);  

    private static String linein = null; // la chane lue

    /**
     * Lit une chane de caractres.
     * Paramtre prompt : le prompt de lecture.
     */
    public static String lireChaine(String prompt) {

	System.out.print(prompt);
	try { linein = in.readLine(); 
	}
	catch (IOException ioexp) {
	    System.out.println("erreur durant la lecture");
	    return "";
	};
	return linein;
    }

    /**
     * Lit un int.
     * Paramtre prompt : le prompt de lecture.
     */
    public static int lireEntier(String prompt) {

	System.out.print(prompt);
	try { linein = in.readLine(); 
	}
	catch (IOException ioexp) {
	    System.out.println("erreur durant la lecture");
	    return 0;
	};
	try {
	    return (Integer.valueOf(linein)).intValue();
	}
	catch (NumberFormatException nfexp) {
	    System.out.println("mauvais int");
	    return 0;
	}
    }

    /**
     * Lit un double.
     * Paramtre prompt : le prompt de lecture.
     */
    public static double lireDouble(String prompt) {

	System.out.print(prompt);
	try { linein = in.readLine(); 
	}
	catch (IOException ioexp) {
	    System.out.println("erreur durant la lecture");
	    return 0.0;
	};
	try {
	    return (Double.valueOf(linein)).doubleValue();
	}
	catch (NumberFormatException nfexp) {
	    System.out.println("mauvais double");
	    return 0.0;
	}
    }

    /**
     * Lit une suite d'int spars par les espaces.
     * Valeur rendue : un tableau contenant les int lus.
     * Paramtre prompt : le prompt de lecture.
     */
    public static int[] lireTableauEntier(String prompt) {

	System.out.print(prompt);
	try { linein = in.readLine(); 
	}
	catch (IOException ioexp) {
	    System.out.println("erreur durant la lecture");
	    return new int[0];
	};

        Vector v = new Vector();
	StringTokenizer st = new StringTokenizer(linein," \t\n\r");
	while ( st.hasMoreTokens() ) {
	    try {
		v.addElement(new Integer(st.nextToken()));
	    }
	    catch (NumberFormatException nfexp) {
		System.out.println("mauvais int");
	    }
	}

	int[] t = new int[v.size()];
	int i = 0;
	
	Enumeration e = v.elements();
	while ( e.hasMoreElements() ) {
	    Integer I = (Integer) e.nextElement();
	    t[i] = I.intValue();
	    i++;
	}

        return t;
    }

    /**
     * Lit une suite d'int spars par les espaces et construit
     * des ObjetAClefs ayant ces int pour clef.
     * Valeur rendue : un tableau contenant ces ObjetAClefs.
     * Paramtre prompt : le prompt de lecture.
     */
    public static ObjetAClef[] lireTableauObjetAClef(String prompt) {

        Hasard r = new Hasard();

	System.out.print(prompt);
	try { linein = in.readLine(); 
	}
	catch (IOException ioexp) {
	    System.out.println("erreur durant la lecture");
	    return new ObjetAClef[0];
	};

        Vector v = new Vector();
	StringTokenizer st = new StringTokenizer(linein," \t\n\r");
	while ( st.hasMoreTokens() ) {
	    try {
		v.addElement(new Integer(st.nextToken()));
	    }
	    catch (NumberFormatException nfexp) {
		System.out.println("mauvais int");
	    }
	}

	ObjetAClef[] t = new ObjetAClef[v.size()];
	int i = 0;
	
	Enumeration e = v.elements();
	while ( e.hasMoreElements() ) {
	    Integer I = (Integer) e.nextElement();
	    t[i] = new ObjetAClef(r.chaine(4),I.intValue());
	    i++;
	}

        return t;
    }

    /**
     * Lit une suite de double spars par les espaces.
     * Valeur rendue : un tableau contenant les double lus.
     * Paramtre prompt : le prompt de lecture.
     */
    public static double[] lireTableauDouble(String prompt) {

	System.out.print(prompt);
	try { linein = in.readLine(); 
	}
	catch (IOException ioexp) {
	    System.out.println("erreur durant la lecture");
	    return new double[0];
	};

        Vector v = new Vector();
	StringTokenizer st = new StringTokenizer(linein," \t\n\r");
	while ( st.hasMoreTokens() ) {
	    try {
		v.addElement(new Double(st.nextToken()));
	    }
	    catch (NumberFormatException nfexp) {
		System.out.println("mauvais double");
	    }
	}

	double[] t = new double[v.size()];
	int i = 0;
	
	Enumeration e = v.elements();
	while ( e.hasMoreElements() ) {
	    Double D = (Double) e.nextElement();
	    t[i] = D.doubleValue();
	    i++;
	}

        return t;
    }

    /**
     * Lit une suite de String spars par les espaces.
     * Valeur rendue : un tableau contenant les Strings lues.
     * Paramtre prompt : le prompt de lecture.
     */
    public static String[] lireTableauChaine(String prompt) {

	System.out.print(prompt);
	try { linein = in.readLine(); 
	}
	catch (IOException ioexp) {
	    System.out.println("erreur durant la lecture");
	    return new String[0];
	};

        Vector v = new Vector();
	StringTokenizer st = new StringTokenizer(linein," \t\n\r");
	while ( st.hasMoreTokens() ) {
	    try {
		v.addElement(st.nextToken());
	    }
	    catch (NumberFormatException nfexp) {
		System.out.println("mauvaise String");
	    }
	}

	String[] t = new String[v.size()];
	int i = 0;
	
	Enumeration e = v.elements();
	while ( e.hasMoreElements() ) {
	    t[i] = (String) e.nextElement();
	    i++;
	}

        return t;
    }
}
