package galerie.controls;

import galerie.Facturation.CataloguePrix;
import galerie.Facturation.Client;
import galerie.Facturation.Facture;
import galerie.Facturation.Panier;
import galerie.IHM.SelectionnerOeuvreVue;
import galerie.IHM.VisualiserFactureVue;
import galerie.galeriePK.Artiste;
import galerie.galeriePK.Oeuvre;

public class ControleurAchatOeuvre {

	/**
	 * @param args
	 * @throws NonIdentifieException 
	 */
	public static void main(String[] args)  {
		initialiser();
		CataloguePrix c = creerCatalogue();
		Client clientCourant;
		try {
			
			clientCourant = new ControleurClient().identifier();
			SelectionnerOeuvreVue vue = new SelectionnerOeuvreVue (Oeuvre.findAll());
			Panier<Oeuvre> oeuvres = vue.selectionnerOeuvres();
			System.out.println(oeuvres);
			System.out.println(clientCourant);
			Facture facture = new Facture(clientCourant, oeuvres, c);
			new VisualiserFactureVue().visualiserFacture(facture);
		} catch (NonIdentifieException e) {
			System.out.println("Seuls les membres peuvent acheter. Voulez-vous devenir Membre? (gratuit)");
		}
	}

	public static void initialiser(){
		creerBaseDesArtistes();
		creerBaseDesOeuvres();
		creerBaseDesClients();
	}
	public static void creerBaseDesOeuvres() {
		Oeuvre nouveau = new Oeuvre("Chopin",Artiste.findByName("Delacroix"));
		nouveau.create();
		nouveau = new Oeuvre("Demoiselle",Artiste.findByName("Matisse"));
		nouveau.create();
		nouveau = new Oeuvre("Eluard",Artiste.findByName("Dali"));
		nouveau.create();
		nouveau = new Oeuvre("Judas",Artiste.findByName("Rembrandt"));
		nouveau.create();
		nouveau = new Oeuvre("Lapidation",Artiste.findByName("Rembrandt"));
		nouveau.create();
		nouveau = new Oeuvre("maya",Artiste.findByName("Picasso"));
		nouveau.create();
		nouveau = new Oeuvre("portrait",Artiste.findByName("Picasso"));
		nouveau.create();
		nouveau = new Oeuvre("Guernica",Artiste.findByName("Picasso"));
		nouveau.create();
	}
	
	public static void creerBaseDesArtistes() {
		Artiste nouveau = new Artiste("Delacroix");
		nouveau.create();
		nouveau = new Artiste("Matisse");
		nouveau.create();
		nouveau = new Artiste("Czanne");
		nouveau.create();
		nouveau = new Artiste("Dali");
		nouveau.create();
		nouveau = new Artiste("Picasso");
		nouveau.create();
		nouveau = new Artiste("Gauguin");
		nouveau.create();
		nouveau = new Artiste("Rembrandt");
		nouveau.create();
	}
	
	public static void creerBaseDesClients(){
        new Client("id0","Doe","john").create();
        new Client("id1","Doe","marie").create();
        new Client("id2","Dupont","mdp").create();
        new Client("id3","Martin","mdp").create();
	}
	
	public static CataloguePrix creerCatalogue() {
		CataloguePrix c = new CataloguePrix();
		c.add(Oeuvre.findByName("Chopin"),200);
		c.add(Oeuvre.findByName("Demoiselle"),400);
		c.add(Oeuvre.findByName("Eluard"),400);
		c.add(Oeuvre.findByName("Judas"),489);
		c.add(Oeuvre.findByName("Lapidation"),250);
		c.add(Oeuvre.findByName("maya"),1250);
		c.add(Oeuvre.findByName("portrait"),1250);
		c.add(Oeuvre.findByName("Guernica"),10250);
		return c;
	}
}
