package galerie.galeriePK;


import java.util.Calendar;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;

public class Artiste implements Cloneable{

	

	/* ****************************
	 * Partie classe "traditionnelle"
	 * 
	 ******************************* */
	private String nom;
//	private String bibliographie = "Non renseigne";
	private Calendar dateNaissance;
	private String prenom = "";
	private String email = "";
	



	/**
	 * Constructeur publique seul accessible aux programmeurs
	 * @param nom
	 */
	public Artiste(String nom) {
		this(nom,"artiste:" + NOMBRE_ARTISTES_CREES );
		NOMBRE_ARTISTES_CREES++;
	}
	
	public int age(){
		Calendar today = Calendar.getInstance();
		int age = today.get(Calendar.YEAR) - dateNaissance.get(Calendar.YEAR);
		today.add(Calendar.YEAR,-age);
		  if(dateNaissance.after(today))
		  {
		    age = age - 1;
		  }
		  return age;
	}
	
	public String getPrenom() {
		return prenom;
	}

	public void setPrenom(String prenom) {
		this.prenom = prenom;
	}

	public String getNom() {
		return nom;
	}

	public void setNom(String nom) {
		this.nom = nom;
	}

//	public String getBibliographie() {
//		return bibliographie;
//	}

//	public void setBibliographie(String bibliographie) {
//		this.bibliographie = bibliographie;
//	}

	public Calendar getDateNaissance() {
		return dateNaissance;
	}

	/**
	 * @param gregorianCalendar the dateNaissance to set
	 */
	public void setDateNaissance(Calendar gregorianCalendar) {
		this.dateNaissance = gregorianCalendar;
	}

	@Override
	public String toString() {
		return "Auteur : " + nom + " " + prenom;
	}


	/* ****************************
	 * Partie classe connexion potentielle  la BD
	 * 
	 * Elle est actuellement implmente comme une classe "Bouchon" qui simule la connexion.
	 ******************************* */
	private String ident;
	
	
	//Simule la base de donne
	private static Dictionary<String,Artiste> LISTE_ARTISTES = new Hashtable<String,Artiste>();
	//Attention cet attribut donne seulement le nombre d'artistes crs par le nombre d'artistes dans la base.
	private static int NOMBRE_ARTISTES_CREES = 0;
	
	
/*	 // Initialisation
	 static {
		   Artiste l = new Artiste("Picasso","picasso00");
		   l.create();
		   l = new Artiste("De Vinci","Leo");
		   l.setPrenom("Leonardo");
		   l.create();
		   l = new Artiste("Queno","mario00");
		   l.setPrenom("mario");
		   l.create();
		   l = new Artiste("Manet");
		   l.create();
		   l = new Artiste("Renoir");
		   l.create();
		   System.out.println("Liste : " + LISTE_ARTISTES);
	 }
*/

	
	private Artiste(String nom, String ident) {
		this.nom = nom;
		this.ident = ident;
	}	
	
	
	
	public void create() {
		// Connexion  la base de donne et Insertion de l'objet dans la base de donnes
//		System.out.println("Insertion de " + this + "dans la base de donnes");
		if (LISTE_ARTISTES != null){
			Artiste a1 = LISTE_ARTISTES.get(ident);
			if (a1 == null) {
				LISTE_ARTISTES.put(ident,(Artiste) this.clone());
			}
		} 
	}
	
	

	public boolean equals(Artiste obj) {
		// TODO Auto-generated method stub
		return ( (this.nom.equals(obj.nom)) && (this.ident.equals(obj.ident) ) );
	}


	/* (non-Javadoc)
	 * @see java.lang.Object#clone()
	 */
	@Override
	public Object clone() {
		Object o = null;
		try {
			o = super.clone();
		} catch(CloneNotSupportedException cnse) {
			// Ne devrait jamais arriver car nous implmentons 
			// l'interface Cloneable
			cnse.printStackTrace(System.err);
		}
		// on renvoie le clone
		return o;
	}

	public void delete() {
		// Connexion  la base de donne et Destruction de l'objet dans la base de donnes
//		System.out.println("Destruction de " + this + "dans la base de donnes");
		LISTE_ARTISTES.remove(this.ident);
	}

	
	public void update() {
		// Connexion  la base de donne et mise  jour de l'objet dans la base de donnes
//		System.out.println("Sauvegarde de " + this + "dans la base de donnes");
		LISTE_ARTISTES.remove(this.ident);
		LISTE_ARTISTES.put(this.ident,(Artiste) this.clone());
	}

	public static Artiste read(String id) {
		// Connexion  la base de donne et mise  jour de l'objet dans la base de donnes
//		System.out.println("Lecture dans la base de donnes");
		return LISTE_ARTISTES.get(id);
	}
	
	public static Artiste findByName(String nom) {
		// Connexion  la base de donne et mise  jour de l'objet dans la base de donnes
		//System.out.println("Lecture dans la base de donnes");
		for (Enumeration<Artiste> e = LISTE_ARTISTES.elements(); e.hasMoreElements() ;) {
			Artiste a = e.nextElement();
			if (a.getNom().equals(nom))
				   return a;
		}
		return null;
	}
	


	/**
	 * @return the ident
	 */
	public String getIdent() {
		return ident;
	}


	public void setEmail(String email) {
		this.email = email;
	}


	public String getEmail() {
		return email;
	}

	
}
