package galerie.galeriePK;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;

/**
 * @author Mireille Blay-fornarino
 *
 */
public class Oeuvre implements Cloneable{

	private String titre;
	private Artiste auteur;
	
	
	/* ****************************
	 * Partie classe "traditionnelle"
	 * 
	 ******************************* */
	//Constructeur ne tenant pas compte de la prsence d'une base de donnes.
	public Oeuvre(String titre, Artiste auteur) {
		this.titre = titre;
		this.auteur = auteur;
	}
	
	public String getTitre() {
		return titre;
	}


	public void setTitre(String titre) {
		this.titre = titre;
	}
	

	public Artiste getAuteur() {
		return auteur;
	}


	public void setAuteur(Artiste auteur) {
		this.auteur = auteur;
	}
	

	
	
	/* ****************************
	 * Partie classe connexion potentielle  la BD
	 * 
	 * Elle est actuellement implmente comme une classe "Bouchon" qui simule la connexion.
	 ******************************* */
	private String ident = "";

	private static int NOMBRE_OEUVRES_CREES = 0;

	/**
	 * Approche "paresseuse" l'identifiant est cr uniquement si besoin.
	 * @return the ident
	 */
	public String getIdent() {
		if (ident.equals("")) {
			ident = "oeuvre:"+ NOMBRE_OEUVRES_CREES;
			NOMBRE_OEUVRES_CREES++;
		}
		return ident;
	}

	/**
	 * @param ident the ident to set
	 */
	public void setIdent(String ident) {
		this.ident = ident;
	}
	
	//Simule la base de donne
	private static Dictionary<String,Oeuvre> LISTE_OEUVRES = new Hashtable<String,Oeuvre>();
	
	public void create() {
		// Connexion  la base de donne et Insertion de l'objet dans la base de donnes
		//System.out.println("Insertion de " + this + "dans la base de donnes");
		LISTE_OEUVRES.put(this.getIdent(),(Oeuvre) this.clone());
	}

	public void delete() {
		// Connexion  la base de donne et Destruction de l'objet dans la base de donnes
		//System.out.println("Destruction de " + this + "dans la base de donnes");
		LISTE_OEUVRES.remove(this.getIdent());
	}

	//Implmentation  l'arrache
	public void update() {
		// Connexion  la base de donne et mise  jour de l'objet dans la base de donnes
		//System.out.println("Sauvegarde de " + this + "dans la base de donnes");
		LISTE_OEUVRES.remove(this.getIdent());
		LISTE_OEUVRES.put(this.getIdent(),(Oeuvre) this.clone());
	}

	public static Oeuvre read(String id) {
		// Connexion  la base de donne et mise  jour de l'objet dans la base de donnes
		//System.out.println("Lecture dans la base de donnes");
		return LISTE_OEUVRES.get(id);
	}
	public static Dictionary<String,Oeuvre> findAll(){
		return LISTE_OEUVRES;
	}
	
	public static Oeuvre findByName(String titre) {
		// Connexion  la base de donne et mise  jour de l'objet dans la base de donnes
		//System.out.println("Lecture dans la base de donnes");
		for (Enumeration<Oeuvre> e = LISTE_OEUVRES.elements(); e.hasMoreElements() ;) {
			Oeuvre a = e.nextElement();
			if (a.getTitre().equals(titre))
				   return a;
		}
		return null;
	}
	
	public boolean equals(Oeuvre obj) {
		return ( (this.titre.equals(obj.titre)) && ((this.ident.equals(obj.ident) &&  (this.auteur.equals(obj.auteur)) ) ) );
	}
	
	
	/* L'artiste n'est pas clon
	 * @see java.lang.Object#clone()
	 */
	@Override
	public Object clone() {
		Object o = null;
		try {
			o = super.clone();
		} catch(CloneNotSupportedException cnse) {
			// Ne devrait jamais arriver car nous implmentons 
			// l'interface Cloneable
			cnse.printStackTrace(System.err);
		}
		// on renvoie le clone
		return o;
	}

	@Override
	public String toString() {
		return ident + " : " + titre + " de " + auteur;
	}
	
}
