package galerie.IHM;

import galerie.Facturation.Panier;
import galerie.galeriePK.Oeuvre;

import java.util.Dictionary;
import java.util.Enumeration;

import algoprog.util.Console;

/**
 * @author mireilleblay-fornarino
 *
 */
public class SelectionnerOeuvreVue {
	private Dictionary<String, Oeuvre>  oeuvres;
	private Panier<Oeuvre> panier;

	public SelectionnerOeuvreVue(Dictionary<String, Oeuvre> oeuvres) {
		this.oeuvres = oeuvres;
		panier = new Panier<Oeuvre>();
		for (Enumeration<Oeuvre> e = oeuvres.elements(); e.hasMoreElements() ;) {
			Oeuvre a = e.nextElement();
			this.visualiser(a);
		}
	}

	/**
	 * @param oeuvres
	 * @return
	 */
	public Panier<Oeuvre> selectionnerOeuvres() {
		
		String encore = "o";
		while (encore.equals("o"))	{
			System.out.println("Oeuvres en Vente");
			//Affichages des oeuvres
			for (Enumeration<Oeuvre> e = oeuvres.elements(); e.hasMoreElements() ;) {
				Oeuvre a = e.nextElement();
				this.visualiser(a);
				//System.out.print(a.getIdent());
				//System.out.println(a);
			}
			String identifiant = Console.lireChaine("Identifiant de l'oeuvre  acheter :");
			//Oeuvre o = Oeuvre.read(identifiant);
			Oeuvre o = oeuvres.get(identifiant);
			if (o != null) {
				oeuvres.remove(identifiant);
				panier.add(o);
				System.out.println("Oeuvre :" + o + " place dans le panier.");
			} else
				System.out.println("L'identifiant ne correspond pas  une oeuvre");
			encore = Console.lireChaine("Encore ?(o/n) :");
		}
		return panier;
	}

	/**
	 * @param o une oeuvre  visualiser
	 */
	public void visualiser(Oeuvre o) {
		System.out.println(o);
	}
}
