package galerie.test.junit;

import java.util.Calendar;
import java.util.GregorianCalendar;

import galerie.galeriePK.Artiste;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

/**
 * @author mireilleblay-fornarino
 *
 */
public class ArtisteTest extends TestCase {


	Artiste c ; 
	
	public ArtisteTest(String name){
		super(name);
	}
	
	public static Test suite() {
		return new TestSuite(ArtisteTest.class);
	}
	
	
	//Appel avant chaque test
	protected void setUp() throws Exception {
		c = new Artiste("Doe");
		super.setUp();
	}
	
	//Appel aprs chaque test
	protected void tearDown() throws Exception {
		super.tearDown();
		c = null;
	}

	
	public void testGetNom() {
		assertEquals("Doe", c.getNom());
	}

	public void testRead() {
		c.create();
		Artiste n = Artiste.read("artiste:1");
		assertEquals("Doe",n.getNom());
	}
	
	public void testCreate() {
		Artiste nouveau = new Artiste("Harry");
		nouveau.create();
		Artiste a = Artiste.read(nouveau.getIdent());
		assertTrue(a.equals(nouveau));
		a = Artiste.read("a");
		assertEquals(a,null);
	}

	public void testDelete() {
		Artiste nouveau = new Artiste("Gauguin");
		nouveau.create();
		//System.out.println("A detruire : " + nouveau);
		Artiste a = Artiste.read(nouveau.getIdent());
		//System.out.println("A lire : " + a);
		assertTrue(a.equals(nouveau));
		nouveau.delete();
		a = Artiste.read(nouveau.getIdent());
		//System.out.println("detruit? : " + a);
		assertEquals(a,null);
	}

	public void testUpdate() {
		c = new Artiste("Czanne");
		c.create();
		c.setNom("Van Gogh");
		String i = c.getIdent();
		//System.out.println(c + " --> ident : " + c.getIdent());
		Artiste n = Artiste.read(i);
		//System.out.println(n + " --> ident : " + n.getIdent());
		assertFalse(n.getNom().equals("Van Gogh"));
		c.update();
		n = Artiste.read(i);
		//System.out.println(n + " --> ident : " + n.getIdent());
		assertTrue(n.getNom().equals("Van Gogh"));
	}

	public void testAge() {
		c.setDateNaissance(new GregorianCalendar(1991, Calendar.JUNE, 12));
		assertEquals(c.age(),19);
	}


	/*public void testSetNom() {
		fail("Not yet implemented");
	}

	public void testGetIdentifiant() {
		fail("Not yet implemented");
	}

	public void testGetMotDePasse() {
		fail("Not yet implemented");
	}

	public void testSetMotDePasse() {
		fail("Not yet implemented");
	}
*/
	
	
	
	public static void main (String args[]) {
		junit.textui.TestRunner.run(suite());
	}
	
}
