package galerie.test.junit;

import galerie.Facturation.Client;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class ClientTest extends TestCase {

	Client c ; 
	
	public ClientTest(String name){
		super(name);
	}
	
	public static Test suite() {
		return new TestSuite(ClientTest.class);
	}
	
	
	//Appel avant chaque test
	protected void setUp() throws Exception {
		c = new Client("doe100","Doe","mdp");
		super.setUp();
	}
	//Appel aprs chaque test
	protected void tearDown() throws Exception {
		super.tearDown();
		c = null;
	}


	public void testToString() {
		String result = "Doe";
		//System.out.println(c);
		assertEquals(result, c.toString());
	}

	public void testGetNom() {
		assertEquals("Doe", c.getNom());
	}

	public void testCreate() {
		Client nouveau = new Client("Harry","Potter","magie");
		nouveau.create();
		boolean b = nouveau.estConnu();
		assertTrue(b);
	}

	public void testDelete() {
		Client nouveau = new Client("Harry","Potter","magie");
		nouveau.create();
		boolean b = nouveau.estConnu();
		assertTrue(b);
		nouveau.delete();
		b = nouveau.estConnu();
		assertFalse(b);
	}

	public void testUpdate() {
		Client nouveau = new Client("Harry","Potter","magie");
		nouveau.create();
		nouveau.setNom("Magicien");
		nouveau.setMotDePasse("mdp");
		nouveau.update();
		Client n = Client.read("Harry");
		assertEquals("Magicien",n.getNom());
		assertEquals("mdp",n.getMotDePasse());	
	}

	public void testRead() {
		c.create();
		Client n = Client.read("doe100");
		assertEquals("Doe",n.getNom());
		assertEquals("mdp",n.getMotDePasse());	
	}

	/*public void testSetNom() {
		fail("Not yet implemented");
	}

	public void testGetIdentifiant() {
		fail("Not yet implemented");
	}

	public void testGetMotDePasse() {
		fail("Not yet implemented");
	}

	public void testSetMotDePasse() {
		fail("Not yet implemented");
	}
*/
	
	public void testEstConnuFalse() {
		Client absent = new Client("Smith","John","mdp");
		boolean b = absent.estConnu();
		assertFalse(b);
	}
	public void testErreurMDP() {
		Client absent = new Client("id0","Doe","mdp");
		boolean b = absent.estConnu();
		assertFalse(b);
	}
	
	public void testEstConnuTrue() {
		Client present = new Client("id0","Doe","john");
		present.create();
		boolean b = present.estConnu();
		assertTrue(b);
	}
	
	public static void main (String args[]) {
		junit.textui.TestRunner.run(suite());
	}
	
	
}
