package galerie.test.junit;


import galerie.galeriePK.Artiste;
import galerie.galeriePK.Oeuvre;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class OeuvreTest extends TestCase {


	Oeuvre c ; 
	Artiste a ; 
	public OeuvreTest(String name){
		super(name);
	}
	
	public static Test suite() {
		return new TestSuite(OeuvreTest.class);
	}
	
	
	//Appel avant chaque test
	protected void setUp() throws Exception {
		a = new Artiste("Matisse");
		c = new Oeuvre("Demoiselle",a);
		super.setUp();
	}
	
	//Appel aprs chaque test
	protected void tearDown() throws Exception {
		super.tearDown();
		c = null;
	}

	public void testRead() {
		c.create();
		Oeuvre n = Oeuvre.read("oeuvre:0");
		assertEquals("Demoiselle",n.getTitre());
		assertTrue(a.equals(n.getAuteur()) );	
	}
	
	public void testCreate() {
		Oeuvre nouveau = new Oeuvre("Eluard",new Artiste("Dali"));
		Oeuvre  a = Oeuvre.read(nouveau.getIdent());
		assertEquals(a,null);
		nouveau.create();
		a = Oeuvre.read(nouveau.getIdent());
		assertTrue(a.equals(nouveau));
	}

	public void testDelete() {
		Oeuvre nouveau = new Oeuvre("Chopin",new Artiste("Delacroix"));
		nouveau.create();
		Oeuvre a = Oeuvre.read(nouveau.getIdent());
		//System.out.println("a" + a + " --> ident : " + c.getIdent());
		//System.out.println(nouveau+ " --> ident : " + nouveau.getIdent());
		assertTrue(a.equals(nouveau));
		nouveau.delete();
		a = Oeuvre.read(nouveau.getIdent());
		assertEquals(null,a);
	}

	public void testUpdate() {
		Oeuvre nouveau = new Oeuvre("Judas",new Artiste("Rembrandt"));
		nouveau.create();
		nouveau.setTitre("Lapidation");
		Oeuvre n = Oeuvre.read(nouveau.getIdent());
		assertFalse(n.getTitre().equals("Lapidation"));
		nouveau.update();
		n = Oeuvre.read(nouveau.getIdent());
		assertTrue(n.getTitre().equals("Lapidation"));		
	}

	
	public static void main (String args[]) {
		junit.textui.TestRunner.run(suite());
	}

}
