<?php
	session_start();
	
	require ('./global/GlobalVariables.php');
	require ('./global/GlobalFunctions.php');

	function __autoload($name) {
		if(strstr($name, CONTROLLER_SUFFIXE)) {//User_Controller
			require ("./controllers/".$name.".php");
		} else if(strstr($name, VIEW_SUFFIXE)){//Login_User_View
				$view = explode('_', $name);
				
				require ("./views/".$view[1]."/".$name.".php");//../views/User/Login.php
		} else {
			require ("./models/".$name.".php");//User
		}
	}
	
	if(!empty($_GET['controller'])) {
		if(_existController($_GET['controller'])) {
			$controllerClass = new ReflectionClass($_GET['controller'].CONTROLLER_SUFFIXE);
		} else {
			_redirect(INDEX_PAGE);
		}
		if($controllerClass->isInstantiable()) {
			$controllerObj = $controllerClass->newInstance();
			
			if(!empty($_GET['action'])) {
					$action = $_GET['action'];
					if(count($_GET) > 2) {
						$params = array();
						foreach($_GET as $getKey => $getValue) {
							if($getKey != "controller" && $getKey != "action") {
								$params[$getKey] = $getValue;
							}
						}
					} else {
						$params = null;
					}
					$action = new ReflectionMethod($_GET['controller'].CONTROLLER_SUFFIXE, $action);
					$action->invoke($controllerObj, $params);
			} else {
					$action = new ReflectionMethod($_GET['controller'].CONTROLLER_SUFFIXE, 'index');
					$action->invoke($controllerObj, null);
			}
		} else {
			_redirect(INDEX_PAGE);//si c'est pas instanciable (ou redirection vers page d'erreur)
		}
	} else {
		_redirect(INDEX_PAGE);//si aucun controller n'est defini
	}
	
	session_write_close();
?>
