
/** Config Parameters **/

var data_url = "data.xml";
var delta = 2;


/** Display Engine **/
function retrieve() {
    new Ajax.Request(data_url,{
		     method:'get',
		     onSuccess: function(msg){ 
			 xmlDoc = msg.responseXML;
			 data = xmlDoc.getElementsByTagName("information");
			 loop(data,0);
		     },
		     onFailure: function(){ alert('Unable to retrieve data!');},
		     onException: function(s,err) { alert('Error: '+err+'!');}
		    });
}

function loop(data, index) {
    if (index >= data.length) {
	// alert('end of data set');
	return retrieve();
    }
    item = data[index];
    display(item);
    window.setTimeout(function(){ loop(data,index+1); }, delta * 1000);
}

function display(information) {
    var author = information.getElementsByTagName("author")[0].textContent;
    var date = information.getElementsByTagName("date")[0].textContent;
    var content = information.getElementsByTagName("content")[0];
    var html = transform(author, date, content);
    $('main').update(html);
}

function transform(author, date, content) {
    var kind = getKind(content);
    var html = bindings[kind].call(this, content);
    var result = "<ul><li>" + author + "</li>";
    result += "<li>" + date + "</li><li>" + html + "</li></ul>";
    return result;
}

/** Information specific implementation **/

var bindings = new Array();
bindings["news"] = function(data) { return data.textContent; }

bindings["menu"] = function(data) {
    var result = "Menu: <ul>";
    var starters = data.getElementsByTagName("starter");
    result += "<li>Starters: ";
    for(var i = 0; i < starters.length; i++)
	result += starters[i].textContent +", ";
    result += "</li>";
    // to do : other tags
    result += "</ul>";
    return result;
} 


/** ugly helper **/
function getKind(element) {
        for(var i = 0; i < element.attributes.length; i++) {
                if ("kind" == element.attributes[i].name)
                        return element.attributes[i].nodeValue;
        }
        return null;    
}

