package pistePK;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingConstants;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.JLabel;

import java.awt.GridLayout;
import javax.swing.JButton;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

import javax.swing.BoxLayout;


public class TableEscrimeFrame extends JFrame implements ScoreListener{

	// private MachineController controller = null;


	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	Score score1=new Score(PlayerType.left);
	Score score2=new Score(PlayerType.right);


	private JPanel contentPane;

	private JPanel contentPanePlayers;

	private final JPanel panelPlayer1 = new JPanel();
	private final JPanel panelPlayer2 = new JPanel();

	private final JPanel panelTimer = new JPanel();

	// Players ================================================================
	private final JPanel panelControl = new JPanel();
	private final JLabel lblWinnerOrNot1 = new JLabel("--");
	private final JLabel lblWinnerOrNot2 = new JLabel("--");
	private final JLabel lblPlayername1 = new JLabel("PlayerName1");
	private final JLabel lblPlayername2 = new JLabel("PlayerName2");
//	private final JTextArea jTAPlayername1 = new JTextArea();
//	private final JTextArea jTAPlayername2 = new JTextArea();
	private final JLabel lbScore1 = new JLabel("0");
	private final JLabel lbScore2 = new JLabel("0");
	private final JButton btnAddScore1 = new JButton("Add Point");
	private final JButton btnAddScore2 = new JButton("Add Point");
//	private final JButton btnSetPlayerName1 = new JButton("Set Player Name");
//	private final JButton btnSetPlayerName2 = new JButton("Set Player Name");

	private int round = 0;
	private final JLabel lblRound = new JLabel("Round");

	// TIMER ================================================================
	private final JLabel lblTimer = new JLabel("Timer");
	private final JButton btnResettime = new JButton("ResetTime");
	private final JButton btnStartTime = new JButton("Start Time");
	private final JButton btnStopTime = new JButton("Stop Time");

	private final JButton btnValidate = new JButton("Validate");
	private final JButton btnNext = new JButton("Next");

	//Create a timer -----
	// Based on http://www.colorado.edu/physics/javaApplets/Maze/StopWatch.java
	public static final int ONE_SEC = 1000;   //time step in milliseconds
	public static final int TENTH_SEC = 100;

	private int clockTick;  	//number of clock ticks; tick can be 1.0 s or 0.1 s
	private double clockTime;  	//time in seconds
	private String clockTimeString; 

	private Font myClockFont;


	Timer countTimer = new Timer(TENTH_SEC, new ActionListener() {
		public void actionPerformed(ActionEvent evt) {
			clockTick++;
			clockTime = ((double)clockTick)/10.0;
			clockTimeString = new Double(clockTime).toString();
			lblTimer.setText(clockTimeString);
			//System.out.println(clockTime);
		}
	});








	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					TableEscrimeFrame frame = new TableEscrimeFrame(new MachineController());
					frame.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}







	/**
	 * Create the frame.
	 */
	public TableEscrimeFrame(final MachineController tableController) {
		//this.controller = tableController;
		score1.addListener(this);
		score2.addListener(this);
		score1.init();
		score2.init();


		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setBounds(100, 100, 450, 700);
		contentPane = new JPanel();
		contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
		setContentPane(contentPane);
		contentPane.setLayout(new BoxLayout(contentPane, BoxLayout.Y_AXIS));


		// Timer Panel-----------------
		contentPane.add(panelTimer);
		panelTimer.setLayout(new GridLayout(0, 1, 0, 0));
		panelTimer.add(lblTimer);
		lblTimer.setHorizontalAlignment(JLabel.CENTER);
		btnStartTime.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				countTimer.start();
			}
		});
		panelTimer.add(btnStartTime);
		btnResettime.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				resetTimer();
			}
		});
		panelTimer.add(btnResettime);
		btnStopTime.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				countTimer.stop();
			}
		});
		panelTimer.add(btnStopTime);
		panelTimer.setBackground(Color.RED);
		resetTimer();
		myClockFont = new Font("Serif", Font.PLAIN, 50);

		lblTimer.setFont(myClockFont);
		lblTimer.setText(clockTimeString);


		// Player Panel---------------------------------------
		contentPanePlayers = new JPanel();
		contentPanePlayers.setBackground(Color.GRAY);

		//contentPanePlayers.setBorder(new EmptyBorder(5, 5, 5, 5));
		//setContentPane(contentPanePlayers);
		contentPanePlayers.setLayout(new GridLayout(0, 3, 0, 0));

		contentPane.add(contentPanePlayers);
		contentPanePlayers.add(panelPlayer1);
		panelPlayer1.setLayout(new GridLayout(0, 1, 0, 0));

		panelPlayer1.add(lblWinnerOrNot1);
		lblWinnerOrNot1.setForeground(Color.GREEN);
		lblWinnerOrNot1.setFont(myClockFont);
		lblWinnerOrNot1.setHorizontalAlignment(JLabel.CENTER);
		panelPlayer1.add(lblPlayername1);
		lblPlayername1.setHorizontalAlignment(JLabel.CENTER);
		panelPlayer1.add(lbScore1);
		lbScore1.setHorizontalAlignment(SwingConstants.CENTER);
		panelPlayer1.add(btnAddScore1);
		btnAddScore1.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				score1.incr();
				//System.out.println("incr 1");
			}
		});
/*		panelPlayer1.add(jTAPlayername1);
		jTAPlayername1.addKeyListener(new KeyAdapter() {
			@Override
			public void keyTyped(KeyEvent e) {
				lblPlayername1.setText(jTAPlayername1.getText()+e.getKeyChar());
			}
		});
		panelPlayer1.add(btnSetPlayerName1);
		btnSetPlayerName1.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				lblPlayername1.setText(jTAPlayername1.getText());
			}
		});*/

		contentPanePlayers.add(lblRound);
		lblRound.setFont(myClockFont);
		lblRound.setHorizontalAlignment(JLabel.CENTER);

		contentPanePlayers.add(panelPlayer2);
		panelPlayer2.setLayout(new GridLayout(0, 1, 0, 0));
		panelPlayer2.add(lblWinnerOrNot2);
		lblWinnerOrNot2.setForeground(Color.GREEN);
		lblWinnerOrNot2.setFont(myClockFont);
		lblWinnerOrNot2.setHorizontalAlignment(JLabel.CENTER);
		panelPlayer2.add(lblPlayername2);
		lblPlayername2.setHorizontalAlignment(JLabel.CENTER);
		panelPlayer2.add(lbScore2);
		lbScore2.setHorizontalAlignment(JLabel.CENTER);
		panelPlayer2.add(btnAddScore2);
		btnAddScore2.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				score2.incr();
			}
		});
/*		panelPlayer2.add(jTAPlayername2);
		jTAPlayername2.addKeyListener(new KeyAdapter() {
			@Override
			public void keyTyped(KeyEvent e) {
				lblPlayername2.setText(jTAPlayername2.getText()+e.getKeyChar());
			}
		});
		panelPlayer2.add(btnSetPlayerName2);


		btnSetPlayerName2.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				lblPlayername2.setText(jTAPlayername2.getText());
			}
		});*/

		// Control Panel
		contentPane.add(panelControl);
		panelControl.setBackground(Color.BLUE);
		panelControl.setLayout(new GridLayout(0, 2, 0, 0));
		btnValidate.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				validate(tableController);
			}


		});
		panelControl.add(btnValidate);
		btnNext.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				initializeNewRound(tableController);
			}


		});
		panelControl.add(btnNext);

	}


	
	//Methods ============

	@Override
	public void scoreChanged(ScoreChangedEvent event) {
		Score s = event.getNewScore();
		setScore(s.getScore(), s.getIdent());
		setName(s.getName(),s.getIdent());
	}
	
	private State getLocalState() {
		State sm = new State(score1,score2,clockTime,round);
		return sm;
	}


	/*private StateMachine getStateMachine() {
		StateMachine sm = new StateMachine(score1,score2,clockTime,round,this);
		return sm;
	}*/
	

	private void resetTimer() {
		clockTick = 0;
		clockTime = ((double)clockTick)/10.0;
		clockTimeString = new Double(clockTime).toString();
		lblTimer.setText(clockTimeString);
	}
	private void resetWinner() {
		lblWinnerOrNot1.setText("---");
		lblWinnerOrNot2.setText("---");
	}

	public void setScore(int score, PlayerType playerNumber){
		if (playerNumber==PlayerType.left)
			lbScore1.setText(Integer.toString(score));
		else
			lbScore2.setText(Integer.toString(score));
	}

	public void setName(String name, PlayerType playerNumber){
		if (playerNumber==PlayerType.left)
			lblPlayername1.setText(name);
		else
			lblPlayername2.setText(name);
	}
	
	
	//@deprecated
	private void initializeNewRound( MachineController controller) {
		//System.out.println("Fin du round avec "+getLocalState().getScoreLeft().getName());
		State state = controller.next(getLocalState());
		if (state == null) {
			btnValidate.setText("Validate");
			//setEnabledButtons(false);
			return;
		}
		//System.out.println("Nouveau round avec "+state.getScoreLeft().getName());
		score1.copyIn(state.getScoreLeft());
		score2.copyIn(state.getScoreRight());
		score1.init();
		score2.init();
		round = state.getRound();
		lblRound.setText(Integer.toString(round));
		resetTimer();
		resetWinner();
		countTimer.stop();
		btnValidate.setText("Validate");
		setEnabledButtons(true);
		btnNext.setEnabled(false);
	}
	
	public void initializeNewRound(State state) {
		//System.out.println("creation d'un nouveau round ");
		score1.copyIn(state.getScoreLeft());
		score2.copyIn(state.getScoreRight());
		score1.init();
		score2.init();
		round = state.getRound();
		lblRound.setText(Integer.toString(round));
		resetTimer();
		resetWinner();
		countTimer.stop();
		btnValidate.setText("Validate");
		setEnabledButtons(true);
		btnNext.setEnabled(false);
		//System.out.println("FIN creation d'un nouveau round ");
	}
	
	
	private void validate(final MachineController controller) {
		countTimer.stop();
		PlayerType pt = controller.validate(getLocalState());
		if (pt==PlayerType.left) {
			lblWinnerOrNot1.setText("WINNER");
			btnValidate.setText("Validate");
			setEnabledButtons(false);
			btnNext.setEnabled(true);
		}
		else if (pt==PlayerType.right) {
			lblWinnerOrNot2.setText("WINNER");
			btnValidate.setText("Validate");
			setEnabledButtons(false);
			btnNext.setEnabled(true);
			}
		else {
			btnValidate.setText("Not Yet, retry");
		}
	}


	public void setEnabledButtons(Boolean b) {
		//System.out.println("On donne l'acces aux bouttons :" + b);
		btnValidate.setEnabled(b);
		btnAddScore1.setEnabled(b);
		btnAddScore2.setEnabled(b);
		btnResettime.setEnabled(b);
		btnStartTime.setEnabled(b);
		btnStopTime.setEnabled(b);
		btnNext.setEnabled(b);
	}







	public void waitForAMatch() {
		//System.out.println("On enleve l'acces aux bouttons");

		setEnabledButtons(false);
		setName("Waiting", PlayerType.left);
		setName("Waiting", PlayerType.right);
		resetWinner();
		
	}
	
	
	public void close(){
		setVisible(false); 
		dispose();
	}
	
	

}
