package pistePK;

import java.util.ArrayList;
import java.util.Iterator;



/**
 * Une FencingPiste est "en therie" connectee a une machine.
 * Ici elle est connectee a une interface graphique qui simule la machine.
 * @author blay
 *
 */
public class FencingPiste {

	int number = 0;
	ArrayList<MatchInterface> matchs = new ArrayList<MatchInterface>();
	MachineController mc;
	int currentMatch = -1; //-1 signifie qu'il n'y a pas de match en cours
	
	
	/**
	 * Le constructeur cree la piste avec sa connexion a l'interface graphique
	 * @param i : numero de la piste
	 * 
	 */
	public FencingPiste(int i) {
		number = i;
		mc = new MachineController(this);
	}

	/**
	 * Aassocie un match a la piste. Il sera joue quand la piste sera "lancee". 
	 * Plusieurs matchs peuvent etre associes a une piste.
	 * Ils seront joues en sequence.
	 * @param match : match a ajouter a la piste
	 */
	public void addMatch(MatchInterface match) {
		matchs.add(match);
	}
	
	/**
	 * Retire tous les matchs associes a la piste.
	 */
	public void clear(){
		matchs.clear();
	}

	@Override
	public String toString() {
		return "FencingPiste [number=" + number + ", matchs=" + toString(matchs) + "]";
	}

	
	private String toString(ArrayList<MatchInterface> matchs) {
		Iterator<MatchInterface> it = matchs.iterator();
		String str = " ";
		while (it.hasNext()) {
			str += it.next() + "--";	
		}
		str = "[" + str + "]" ;
		return str;
	}
	
	
	/**
	 * @return vraie si tous les matchs ont ete joues ou si la piste n'a pas encore ete lancee.
	 */
	public boolean isOver(){
		return ( (currentMatch==-1)|| (matchs.size()<=currentMatch) );
	}
	
	
	
	
	/**
	 * Declenche la piste qui lance le premier match enregistre sur la piste.
	 */
	public void start(){
		System.out.println("Redemarrage de la piste : "+ number);
		currentMatch = -1;
        next();
        
	}

	public void memorizeWinner(String matchWinner) {
		System.out.println("Memorisation du gagnant de " + currentMatch + " : " + matchWinner);
		 matchs.get(currentMatch).setWinner(matchWinner);
	}

	/**
	 * Cette methode est essentiellement appelee par la machine pour recuperer les matchs suivants.
	 * Elle lance le prochain match.
	 * S'il n'y a plus de match a jouer, la piste se met en attente.
	 * Sinon la machine est initialisee avec le prochain match qui peut alors commencer.
	 * 
	 */
	public void next() {
//		System.out.println("NEXT sur piste ");
		if (matchs.isEmpty()){
			System.out.println("pas de matchs");
			mc.waitForAMatch();
			return;
		}
		currentMatch+=1;
		if (matchs.size()<=currentMatch) {
			System.out.println("plus de matchs :" + matchs.size() + " : " + currentMatch);
			mc.waitForAMatch();
			return;
		}
        
		
		MatchInterface m = matchs.get(currentMatch);
	//	System.out.println("next sur PIST : "+ currentMatch + " : " + m);
		mc.initialize(new MatchMG(
				m.getLeftPlayer(), 
				m.getRightPlayer()) );
	//	System.out.println("FIN next pist sur : "+ currentMatch + " : " + m);
		
	}
	
	/**
	 * Cloture la piste et ferme proprement l'interface graphique correspondante.
	 */
	public void close(){
		mc.close();
	}
	

	
	
}
