package pistePK;

import java.util.Random;



/* -----------------------------------
 * 
 * VERSION DE TESTS A COMPLETER
 * 
 * ----------------------------------
 */

public class MachineController {

	public static final int THREE_MINUTES = 60 * 3;
	public static final int TWO_MINUTES =  60 * 2;
	public static final int ONE_MINUTE =  60 ;


	Random randomGenerator = new Random();
	TableEscrimeFrame table;
	
	MatchMG currentMatch;
	RoundMG currentRound ;
	FencingPiste pist;
	
	public MachineController() {
		
		table = new TableEscrimeFrame(this);
		table.setVisible(true);
		this.waitForAMatch();
	}
	
	public MachineController(FencingPiste pist) {
		this();
		this.pist = pist;
	}
	
	
	// Elle valide la difference de score et le timer et retourne le vainqueur s'il y a ou une erreur dans le cas contraire
	// Le round associe est valide pour le joueur gagnant.
	
	public PlayerType validate(State state) {
		// Si l'ecart est suffisant, on recherche le gagnant
		int scoreLeft = state.getScoreLeft().getScore();
		int scoreRight = state.getScoreRight().getScore();

		int max = Math.max(scoreLeft,scoreRight);

		if ( Math.abs(scoreLeft-scoreRight)  > 1 && max > 4)
			return getTheWinner(scoreLeft, scoreRight);
		else //pas assez d'ecart ou le 5 non atteint
			if (state.getClockTime() < THREE_MINUTES) {
				//System.out.println("temps non atteint et pas assez de difference");
				return PlayerType.fail; // le round doit continuer
			}
			else // on a atteint la limite des 3 minutes
				if (state.getClockTime() < (THREE_MINUTES + TWO_MINUTES) )
					if (scoreLeft == scoreRight) // si on n'a pas depasser 5min on continue
						return PlayerType.fail;
					else
						return getTheWinner(scoreLeft, scoreRight);
				else {// le temps max est atteint
					//System.out.println("temps depasse");
					if (scoreLeft == scoreRight) { // on tire au sort
						int randomInt = randomGenerator.nextInt(1);
						if (randomInt == 0) {
							memorizeRound(scoreLeft, scoreRight, PlayerType.left); 
							return PlayerType.left;
						}
						else {
							memorizeRound(scoreLeft, scoreRight, PlayerType.right); 
							return PlayerType.right;
						}
					}
					else
						return getTheWinner(scoreLeft, scoreRight);
				}
	}
	
	private PlayerType getTheWinner(int scoreLeft, int scoreRight) {
		if (scoreLeft > scoreRight) {
			memorizeRound(scoreLeft, scoreRight, PlayerType.left); 
			return PlayerType.left;
		}
		else
			if (scoreLeft < scoreRight) {
				 memorizeRound(scoreLeft, scoreRight, PlayerType.right); 
			     return PlayerType.right;
			}
			else
				return PlayerType.fail;
	}						
	
	private void memorizeRound(int scoreLeft, int scoreRight, PlayerType winner) {
		currentRound.setScore(scoreLeft, PlayerType.left);
		currentRound.setScore(scoreRight, PlayerType.right);
		currentRound.setWinner(winner);
	}


	//construit un nouvel etat pour la machine qui redemarre
	//Est-ce que l'on verifie que le round precedent est termine?
	// oui on va le faire dans validate
	// ici on remplace le round precedent par un nouveau
	// si l'ancien n'a pas eta valide on enregestrie qu'il s'est mal passe
	// QUAND LE ROUND EST TERMIINe LA COMPETITION EST PREVENUE.
	public State next(State state) {
		System.out.println("NEXT sur machineController ");
		if (currentRound.getNumber() == Constants.MAX_ROUND) {
			//match termine -- 
			System.out.println("Match termine!!");
			pist.memorizeWinner(getMatchWinner());
			pist.next();
			System.out.println("FIN NEXT sur machineController ");
			return null;
/*			return new State(new Score("--",PlayerType.left), 
	                new Score("--",PlayerType.right),
	                0.0,//timer
	                0//round
	                );*/
			}
		else {
			System.out.println("New Round!!");
			currentRound = new RoundMG((currentRound.getNumber())+1);
			currentMatch.addRound(currentRound);
			return new State(
					state.getScoreLeft().cloneWithoutScore(),
					state.getScoreRight().cloneWithoutScore(),
					0.0,
					currentRound.getNumber()) ;
		     }
	}

		
	private String getMatchWinner() {
		int left = 0;
		for (RoundMG r : currentMatch.rounds)
			if (r.winner == PlayerType.left)
				left +=1;
		System.out.println("Nombre de Left : " + left );
		if (left > (Constants.MAX_ROUND - left))
			return currentMatch.getPlayerName(PlayerType.left);
		else
			return currentMatch.getPlayerName(PlayerType.right);
	}

	public void initialize(MatchMG match) {
		System.out.println("initialisation avec un nouveau match !");
		currentMatch = match;
		int roundNumber = 1;
		currentRound = new RoundMG(1);
		Score scLeft = new Score(match.getLeftPlayer(), PlayerType.left);
		Score scRight = new Score(match.getRightPlayer(), PlayerType.right);
		State sm = new State(scLeft, scRight, 0, roundNumber);
		table.initializeNewRound(sm);
		match.addRound(currentRound);
		System.out.println("FIN initialisation avec un nouveau match !");
	}
    
	public void waitForAMatch(){
		System.out.println("Mise en attente de la table");
		table.waitForAMatch();
	}

	public void close() {
		table.close();
	}

}
	