package pistePK;

import javax.swing.event.EventListenerList;



public class Score {
	



	int score = 0;
	String name = "unknown";
	PlayerType ident = PlayerType.left;

	private EventListenerList listeners;
	
	
	/*private EventListenerList getListeners() {
		return listeners;
	}
	*/
	public void addListener(ScoreListener listener) {
		this.listeners.add(ScoreListener.class,listener);
	}
;
	
	public int getScore() {
		return score;
	}
	public void setScore(int score) {
		this.score = score;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
		
	}
	public PlayerType getIdent() {
		return ident;
	}
	public void setIdent(PlayerType ident) {
		this.ident = ident;
	}
	
	

	public Score(PlayerType i) {
		ident = i;
		listeners = new EventListenerList();
	}
	public Score(String name , PlayerType i) {
		this(i);
		this.name = name;
		scoreChanged();
	}
	public Score(int score, String name , PlayerType i) {
		this(name,i);
		this.score = score; 
	}
	public void incr() {
		score++;
		System.out.println("incr dans score:" + score);
		scoreChanged();
		
	}
	public void reset() {
		score=0;
	}

	public void init() {
		scoreChanged();
		
	}

	public void scoreChanged(){
		ScoreListener[] listenerList = (ScoreListener[])listeners.getListeners(ScoreListener.class);		
		for(ScoreListener listener : listenerList){
			listener.scoreChanged(new ScoreChangedEvent(this));
		}
	}
	public Score cloneWithoutScore() {
		return new Score(0,name, ident);
	}
	
	public void copyIn(Score s){
		score = s.getScore();
		name = s.getName();
		ident = s.getIdent();
	}
	
}

