package iut.capteurs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CapteurPassifReactif extends CapteurPassif {

	public CapteurPassifReactif(CapteurPhysique capteurPhysique) {
		super(capteurPhysique);
	}

	private List<ObserverDeCapteur> observers = new ArrayList<ObserverDeCapteur>();

	public void register(ObserverDeCapteur obj) {
		if(!observers.contains(obj)) 
			observers.add(obj);
	}

	public void unregister(ObserverDeCapteur obj) {
		observers.remove(obj);
	}


	//Je fais le choix de faire passer la valeur, c'est la seule chose qui m'interesse.
	public void notifyObservers(String valeurCourante) {
		for (ObserverDeCapteur obj : observers) {
			obj.update(valeurCourante);
		}
	}

	public void setValeur(String valeur) throws IOException, NonAccessibleCapteurException{
		super.setValeur(valeur);
		notifyObservers(valeur+"");
	}
	


}
