package iut.capteurs;

import iut.fileIO.FichierIO;

import java.io.File;
import java.io.IOException;

/**
 * Un capteur physique prend ses valeur dans un fichier 
 * qui a pour nom le nom du capteur + .data
 * 
 * @author blay
 *
 */
public class CapteurPhysique {
	
	private File fichier;
	
	public String getName() {
		String name = fichier.getName();
		return fichier.getName().substring(0, name.length()-5);
	}
  
	public String getValeur() throws NonAccessibleCapteurException {
		try {
			return FichierIO.lire1Ligne(fichier);
		} catch (IOException e) {
			throw new NonAccessibleCapteurException(this,e);
		}
    }
    
    public CapteurPhysique(String name) {
		this.fichier = new File(name+".data");
	}

	public void setValeur(String value) throws NonAccessibleCapteurException {
		try {
			FichierIO.ecrire(fichier,value);
		} catch (IOException e) {
			throw new NonAccessibleCapteurException(this,e);
		}
    }
	
}
