package iut.maisonNumerique;

import iut.capteurs.Capteur;

import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;

public class Maison implements Observer {
   private ArrayList<Piece> pieces = new ArrayList<Piece>();
   private TableauDeBord tableau = new TableauDeBord();

public Maison(ArrayList<Piece> pieces) {
	this.pieces = pieces;
	for (Piece p : pieces) {
		p.addObserver(this);
		System.err.println("addObserver  " + p  + "avec" + this);
	}
	enregistreCapteursDansTableau(pieces);
}

private void enregistreCapteursDansTableau(ArrayList<Piece> pieces) {
	for (Piece p : pieces)
	  tableau.addCapteurs(p.getCapteurs());
	
}

@Override
public String toString() {
	return "Maison [pieces=" + pieces + "],\n" + tableau.visualise() + "";
}

@Override
public void update(Observable arg0, Object arg1) {
	System.err.println("update" + arg0 + "avec" + arg1);
	if (Capteur.class.isInstance(arg1))
			tableau.addCapteur((Capteur)arg1);
}




}
