package iut.maisonNumerique;
import java.util.ArrayList;
import java.util.Observable;

import iut.capteurs.*;


public class Piece extends Observable{
	
	String name;
	
	public Piece(String name) {
		super();
		this.name = name;
	}

	ArrayList<Capteur> capteurs = new ArrayList<Capteur>();
	
	public ArrayList<Capteur> getCapteurs() {
		return capteurs;
	}

	public void setCapteurs(ArrayList<Capteur> capteursPassifs) {
		this.capteurs = capteursPassifs;
	}
	

	public void addCapteur(Capteur cp){
		capteurs.add(cp);
		setChanged();
		System.err.println("notify");
		notifyObservers(cp);
	}
	
	
	
	public String getValeurs(){
		String s = name + "\n";
		for (Capteur cp : capteurs)
			s += "\t"+ cp.getNom() + ":" + cp.getValeur();
		return s;
	}

	@Override
	public String toString() {
		return "Piece [name=" + name + ", capteurs=" + capteurs + "]";
	}
	

}
