package busPk;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;

public class Bus {
	private String nom;
	public ArrayList<Message> messages = new ArrayList<Message>();

	public Bus(String aNom) {
		nom = aNom;
	}

	public void send(Message aM) {
		aM.setDateNow();
		messages.add(aM);
	}

	public int detruireMessages(Date aPlusVieuxQue) {
		ArrayList<Message> selectedMessages = getMessagesAvant(aPlusVieuxQue);
		for (Message m : selectedMessages)
			detruire(m);
		return selectedMessages.size();
	}

	public boolean detruire(Message aM) {
		return messages.remove(aM);
	}

	public ArrayList<Message> getMessagesAvant(Date aPlusVieuxQue) {
		ArrayList<Message> selectedMessages = new ArrayList<Message>();
		for (Message m : messages) {
			if (m.getDateEmission().before(aPlusVieuxQue))
				selectedMessages.add(m);
		}
		return selectedMessages;
	}

	public ArrayList<Message> getMessages() {
		return messages;
	}
}