/**
 * 
 */
package busPk;

import static org.junit.Assert.*;

import java.util.ArrayList;
import java.util.Date;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

/**
 * @author blay
 *
 */
public class BusTest {

	protected Bus b ;
	Message m0 = new Message("test0");
	Message m1 = new Message("test1");
	/**
	 * @throws java.lang.Exception
	 */
	@Before
	public void setUp() throws Exception {
		b = new Bus("test");
		m0 = new Message("test0");
		m1 = new Message("test1");
	}

	/**
	 * @throws java.lang.Exception
	 */
	@After
	public void tearDown() throws Exception {
		b = new Bus("test");
		m0 = new Message("test0");
		m1 = new Message("test1");
	}

	@Test
	public void testPasDeMessageAprsConstruction() {
		assertEquals(0, (b.getMessages().size()) );
	}
	
	@Test
	public void testAjoutDeMessage() {
		b.send(m0);
		Date d = m0.getDateEmission();
		Date d1 = new Date();
		assertEquals(1, (b.getMessages().size()) );
		assertEquals(d1,d);
		b.send(m1);
		assertEquals(2, (b.getMessages().size()) );
	}
	
	@Test
	public void testDetruireMessage() {
		b.send(m0);
		assertEquals(1, (b.getMessages().size()) );
		assertTrue(b.detruire(m0));
		assertEquals(0, (b.getMessages().size()) );
		b.send(m0);
		b.send(m1);
		assertTrue(b.detruire(m0));
		assertEquals(1, (b.getMessages().size()) );
		b.send(m0);
		assertTrue(b.detruire(m0));
		assertEquals(1, (b.getMessages().size()) );
		assertTrue(b.detruire(m1));
		assertEquals(0, (b.getMessages().size()) );
	}
	
	@Test
	public void testDetruireMessages() throws InterruptedException {
		b.send(m0);
		b.send(new Message("autre test"));
		Thread.sleep(100);
		Date d0= new Date();
		Thread.sleep(1000);
		Date d1= new Date();
		b.send(m1);
		b.send(new Message("plus tard"));
		assertEquals(2, b.detruireMessages(d0));
		assertEquals(2,b.getMessages().size());
		assertTrue(b.getMessages().contains(m1));
		assertFalse(b.getMessages().contains(m0));
	}

	@Test
	public void tesGetMessagesAvant() throws InterruptedException {
		b.send(m0);
		b.send(new Message("autre test"));
		Thread.sleep(100);
		Date d0= new Date();
		Thread.sleep(1000);
		b.send(m1);
		b.send(new Message("plus tard"));
		ArrayList<Message> l = b.getMessagesAvant(d0);
		assertEquals(2, l.size());
		assertFalse(l.contains(m1));
		assertTrue(l.contains(m0));
		Thread.sleep(100);
		l=b.getMessagesAvant(new Date());
		assertEquals(4, l.size());
		assertTrue(l.contains(m1));
		assertTrue(l.contains(m0));
		
	}

	
	
	

}
