package busV2.busPK;

import java.util.Date;

public class Message {
	private Date dateEmission;
	private String contenu;
	//Non accessible depuis l'extrieur.
	private Boite b;

	// On n'est pas autoris  crer un message en dehors du package.
	protected Message(String aContenu, Boite boite) {
       contenu = aContenu;
       dateEmission = new Date();
       b = boite;
    }

    public void setDateNow() {
		dateEmission = new Date();
	}

    protected void detruire() {
        b.detruire(this);
        b = null;
        
    }
    
    //verifie si le message est plus vieux que le nombre de seconds passes en paramtres.
    public boolean perime(int second){
        Date d = new Date();
        long ms = d.getTime();
        ms = ms - second*1000;
        d.setTime(ms);
        return this.dateEmission.before(d);
    }

    @Override
    public String toString() {
        return "\n\t\t Message [dateEmission=" + dateEmission + ", contenu=" + contenu
                + "]";
    }
    
    
}