package societesDetransports;

import java.util.Observer;


/**
 * WARNING : Ce code ne vise pas plus que de prsenter un code possible pour amorcer la mise en oeuvre du TD7 
 * La classe Agence joue le rle de ConcreteFactory dans le pattern "abstract Factory". 
 * Elle est cependant plus riche puisqu'elle cre elle-mme deux autres factory  qui elle dlgue des tches. 
 * @author blay
 *
 *
 */
public class Agence extends SocieteTransport{
	

	public Agence() {
		super("Agence");
	}

	SocieteTransport fedUT = FedUt.getInstance();
	SocieteTransport dhlUT = new DHLUT("DHLut");
	
	@Override
	public int prochaineDateLivraison() {
		int fedUTDate = fedUT.prochaineDateLivraison();
		int dhlUTDate = dhlUT.prochaineDateLivraison();
		if (fedUTDate< dhlUTDate)
			return fedUTDate;
		else
			return dhlUTDate;
		
	}

	private SocieteTransportInterface selectionnerSocieteTransport(){
		if (fedUT.prochaineDateLivraison() < dhlUT.prochaineDateLivraison())
			return fedUT;
		else
			return dhlUT;
	}
	
	public TicketSuivi creerOrdreTransport(String entrepot, String adresse, String colis){
		SocieteTransportInterface st = selectionnerSocieteTransport();
		TicketSuivi ts = st.creerOrdreTransport(entrepot, adresse, colis);
		return ts;
	}


	public void addObserver(Observer o){
		fedUT.addObserver(o);
		dhlUT.addObserver(o);
		super.addObserver(o);
	}



	
}
