package societesDetransports;

import java.util.HashMap;
import java.util.Observer;

/**
 * @author blay
 *
 * AbstractFactory
 * On a utilis une interface pour faciliter la comprhension 
 * mais elle n'est pas vraiment utilise
 */
public abstract class SocieteTransport implements SocieteTransportInterface {
	private static HashMap<Integer, OrdreTransport> ORDRES = new HashMap<Integer, OrdreTransport>();
	private static  int Nombre_Ordres = 0;
	
	private String nom;
	
	//On aurait pu en faire un obeserver java
	//mais au moment o on en a eu besoin elle hritait dj d'une autre classe (un bon refactoring serait donc une bonne ide...)
	//On choisit de faire un "Adaptateur" pour se simplier la vie. Nous lui dlguons toutes les tches d'onservation.
	private AdapterObservable obs = new AdapterObservable();
	
	@Override
	public String toString() {
		return " -- " + nom + " ";
	}

	public void addObserver(Observer o){
		obs.addObserver(o);
	}
	
	public SocieteTransport(String nom) {
		super();
		this.nom = nom;
	}

	/* (non-Javadoc)
	 * @see societesDetransports.SocieteTransportInterface#creerOrdreTransport(java.lang.String, java.lang.String, java.lang.String)
	 */
	@Override
	public  TicketSuivi creerOrdreTransport(String entrepot, String adresse, String colis){
		OrdreTransport o = new OrdreTransport(this,entrepot,adresse,colis);
		int livraison = prochaineDateLivraison();
		int numeroSuivi = Nombre_Ordres++;
		TicketSuivi ts = new TicketSuivi(livraison, numeroSuivi);
		o.setTicketSuivi(ts);
		TicketRetrait tr = new TicketRetrait(colis,ts);
		ORDRES.put(numeroSuivi, o);
		obs.setChanged();
		obs.notifyObservers(o);
		return ts;
	}
	
	public abstract int prochaineDateLivraison();
	
	/* (non-Javadoc)
	 * @see societesDetransports.SocieteTransportInterface#signalerEtat(int, societesDetransports.EtatColis)
	 */
	@Override
	public void signalerEtat(int numero, EtatColis ec){
		OrdreTransport o = ORDRES.get(Integer.valueOf(numero));
		o.setEtat(ec);
		obs.setChanged();
		obs.notifyObservers(o);
	}
	
	/* (non-Javadoc)
	 * @see societesDetransports.SocieteTransportInterface#getEtat(int)
	 */
	@Override
	public EtatColis getEtat(int numero){
		OrdreTransport o = ORDRES.get(Integer.valueOf(numero));
		return o.getEtat();
	}
	
	public OrdreTransport getOrder(int numero) {
		// TODO Auto-generated method stub
		return ORDRES.get(Integer.valueOf(numero));
	}
	
	

	public void delete(int order) {
		OrdreTransport o = ORDRES.remove(Integer.valueOf(order));
		obs.setChanged();
		obs.notifyObservers("Suppression de " + o);
		
	}
	
}
