package iut.capteurs;

import static org.junit.Assert.*;
import iut.fileIO.FichierIO;

import java.io.File;
import java.io.IOException;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class CapteurPhysiqueTest {

	CapteurPhysique cpPermanent = new CapteurPhysique("cpPermanent");
	CapteurPhysique cpTemporaire;	
	@Before
	public void setUp() throws Exception {
		File f = new File("cp1.data");
		f.delete();
		cpTemporaire = new CapteurPhysique("cp1");
	}

	@After
	public void tearDown() throws Exception {

	}
	
	@Test  
	public void testCapteurInitial() {
		File f = new File("cp1.data");
		assertFalse(f.exists());
	}

	@Test(expected = NonAccessibleCapteurException.class)
	public void testAccessProblem() throws NonAccessibleCapteurException {
		CapteurPhysique cpPermanentError = new CapteurPhysique("cpPermanentError");
		String[] valeurs = {cpPermanentError.getValeur()};
	}
	
	
	@Test
	public void testCapteurSetValeur() throws IOException, NonAccessibleCapteurException {
		cpTemporaire.setValeur("12.2");
		File f = new File("cp1.data");
		System.out.println("Affectation ok");
		String val = FichierIO.lire1Ligne(f);
		System.out.println("je lis" + val);
		String[] valeurs = {val};
		String [] expected = {"12.2"};
		assertArrayEquals(expected, valeurs);
	}
	
    @Test
	public void testCapteurFichierRenseigne() throws IOException, NonAccessibleCapteurException {
		cpTemporaire.setValeur("12.2");
		String val = cpTemporaire.getValeur();
		String[] valeurs = {val};
		String [] expected = {"12.2"};
		assertArrayEquals(expected, valeurs);
	}
    
    
    @Test
	public void testCapteurPermanent() throws IOException, NonAccessibleCapteurException {
		String val = cpPermanent.getValeur();
		String[] valeurs = {val};
		String [] expected = {"17.8"};
		assertArrayEquals("La valeur attendue des tests automatiques est 17.8", expected, valeurs);
	}
	

}

