package iut.maisonNumerique;

import static org.junit.Assert.*;

import java.io.File;
import java.io.IOException;

import iut.capteurs.CapteurPassif;
import iut.capteurs.CapteurPassifReactif;
import iut.capteurs.CapteurPhysique;
import iut.capteurs.NonAccessibleCapteurException;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class SmartPieceTest {

	@Before
	public void setUp() throws Exception {
	}

	@After
	public void tearDown() throws Exception {
		File f = new File("thermometre.data");
		f.delete();
		f = new File("humidite.data");
		f.delete();
		f = new File("lumiere.data");
		f.delete();
	}

	@Test
	public void test() throws IOException, NonAccessibleCapteurException {
		SmartPiece p = new SmartPiece("Salon");
		CapteurPassif termometre = new CapteurPassif(new CapteurPhysique("thermometre"));
		CapteurPassif humidite = new CapteurPassif(new CapteurPhysique("humidite"));
		CapteurPassif lumiere = new CapteurPassif(new CapteurPhysique("lumiere"));
		CapteurPassifReactif presence = new CapteurPassifReactif(new CapteurPhysique("presence"));
		CapteurPassifReactif luminosite = new CapteurPassifReactif(new CapteurPhysique("luminosite"));		
		p.addCapteur(termometre);
		p.addCapteur(humidite);
		p.addCapteur(lumiere);
		System.out.println("On attend --------- un enregistrement");
		p.addCapteur(presence);
		p.addCapteur(luminosite);
		String s ;
		//s = p.getValeurs();
		//System.out.println("Avant affectation :" + s);
		termometre.setValeur("19");
		humidite.setValeur("12.7");
		lumiere.setValeur("120");
        s = p.getValeurs();
		System.out.println("Apres affectation des passifs : " + s);
	    luminosite.setValeur("150");
	    presence.setValeur("1");
	    presence.setValeur("1");
	    presence.setValeur("0");
	}

}
