package iut.capteurs;

import java.io.IOException;

import org.easymock.EasyMockRunner;
import org.easymock.EasyMockSupport;
import org.easymock.Mock;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.After;
import org.junit.Before;

@RunWith(EasyMockRunner.class)

public class CapteurPassifReactifTest extends EasyMockSupport {

	CapteurPassifReactif cpTemporaire ;
	
    @Mock
    private ObserverDeCapteur observeur; 
    @Mock
    private ObserverDeCapteur observeur2; 
	
	@Before
	public void setUp() throws Exception {
		  cpTemporaire = new CapteurPassifReactif(new CapteurPhysique("cp1"));		
	}

	@After
	public void tearDown() throws Exception {
		cpTemporaire.unregister(observeur);
	}

	//tests du Mock
	@Test
	public void testCapteurSetValeur() throws IOException, NonAccessibleCapteurException {
		observeur.update("12.2"); //Appel attendu
	    replayAll(); //Memoriser
	    cpTemporaire.register(observeur);
		cpTemporaire.setValeur("12.2");
        verifyAll(); //Verification
    }
	
	
	//tests du Mock
	@Test
	public void testCapteurSetValeurMultipleObserveurs() throws IOException, NonAccessibleCapteurException {
		observeur2.update("12.2");//
		observeur.update("12.2"); //Appel attendu
	    replayAll(); //Memoriser
	    cpTemporaire.register(observeur);
	    cpTemporaire.register(observeur2);
		cpTemporaire.setValeur("12.2");
        verifyAll(); //Verification
    }
	

}
