package iut.capteurs;

import static org.junit.Assert.*;

import java.io.File;
import java.io.IOException;

import iut.fileIO.FichierIO;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class CapteurPassifTest {

	CapteurPassif cpTemporaire ;
	CapteurPhysique cphysiquePermanent = new CapteurPhysique("cpPermanent");
	private Capteur cpPermanent = new CapteurPassif(cphysiquePermanent);
	
	@Before
	public void setUp() throws Exception {
		File f = new File("cp1.data");
		f.delete();
		cpTemporaire = new CapteurPassif(new CapteurPhysique("cp1"));	
		
	}

	@After
	public void tearDown() throws Exception {
	}
	
/*	@Test  
	public void testCapteurInitial() {
		File f = new File("cp1.data");
		assertFalse(f.exists());
	}*/

	@Test
	public void testCapteurFichierVide() {
		String val = cpTemporaire.getValeur();
		String[] valeurs = {val};
		String[] expecteds = {"Non trouvee"};
		assertArrayEquals(expecteds, valeurs);
	}
	
	@Test
	public void testCapteurSetValeur() throws IOException, NonAccessibleCapteurException {
		cpTemporaire.setValeur("12.2");
		File f = new File("cp1.data");
		String val = FichierIO.lire1Ligne(f);
		String[] valeurs = {val};
		String [] expected = {"12.2"};
		assertArrayEquals(expected, valeurs);
	}
	
    @Test
	public void testCapteurFichierRenseigne() throws IOException, NonAccessibleCapteurException {
		cpTemporaire.setValeur("12.2");
		String val = cpTemporaire.getValeur();
		String[] valeurs = {val};
		String [] expected = {"12.2"};
		assertArrayEquals(expected, valeurs);
	}
    
    
    @Test
	public void testCapteurPermanent() throws IOException {
		String val = cpPermanent.getValeur();
		String[] valeurs = {val};
		String [] expected = {"17.8"};
		assertArrayEquals("La valeur attendue des tests automatiques est 17.8", expected, valeurs);
	}
	

}
