package iut.fileReader;

import static org.junit.Assert.*;
import iut.fileIO.FichierIO;

import java.io.File;
import java.io.IOException;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class LecteurFichierTest {

	File fTemporaire ;
	private File fPermanent;
	private File fEcriture;
	
	@Before
	public void setUp() throws Exception {
		fTemporaire = new File("temp"+".data");
		fPermanent = new File("permanent"+".data");
		fEcriture = new File("ecriture"+".txt");
	}

	@After
	public void tearDown() throws Exception {
		fTemporaire.delete();
		
	}

	@Test(expected = java.io.FileNotFoundException.class)  
	public void testFichierInexistant() throws IOException {
		FichierIO.lire1Ligne(fTemporaire);
		String[] valeurs = {"aa"};
		assertArrayEquals(null, valeurs);
	}
	
	@Test
	public void testEcitureFichier() throws IOException {
		FichierIO.ecrire(fTemporaire, "12.2");
	}
	
	@Test
	public void testEcitureDANSFichier() throws IOException {
		FichierIO.ecrireDans(fEcriture, "XXX");
		FichierIO.ecrireDans(fEcriture, "YYYY");
	}
	
	@Test
	public void testLectureFichier() throws IOException {
		FichierIO.ecrire(fTemporaire, "12.2");
		String val = FichierIO.lire1Ligne(fTemporaire);
		String[] valeurs = {val};
		String[] expecteds = {"12.2"};
		assertArrayEquals(expecteds, valeurs);
	}
	
	@Test
	public void testLectureFichierDerniereLigne() throws IOException {
		FichierIO.ecrire(fTemporaire, "12.2");
		FichierIO.ecrire(fTemporaire, "14.2");
		FichierIO.ecrire(fPermanent, "14.2");
		String val = FichierIO.lire1Ligne(fTemporaire);
		String[] valeurs = {val};
		String[] expecteds = {"14.2"};
		assertArrayEquals(expecteds, valeurs);
	}
	

}
