package iut.fileIO;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

/**
 * Classe utilise pour simplifier la lecture et l'criture dans des fichiers.
 * On peut tout  fait s'en passer.
 * @author blay
 *
 */
/**
 * @author blay
 *
 */
public abstract class FichierIO {
	

	/**
	 * @param fichier dans lequel lire.
	 * @return la ligne lue
	 * @throws IOException
	 */
	public static String lire1Ligne(final File fichier) throws IOException {
		BufferedReader in = new BufferedReader(new FileReader(fichier));
		String line = in.readLine();
 	    in.close();  
 	    return line;
     }
	
	/**
	 * Cette mthode crit dans le fichier en effaant le contenu antrieur.
	 * @param fichier
	 * @param ligne  crire en dbut du fichier.
	 * @throws IOException
	 */
	public static void ecrire(final File fichier, final String ligne) throws IOException {
		FileWriter fw = null;
	    try {
	      fw = new FileWriter(fichier);
	      fw.write(ligne);
	    } catch (Exception e) {
	      throw new RuntimeException(e);
	    } finally {
	    	fw.close();
	    }

     }
	
	
	//Cette mthode crit  la fin du fichier.
	
	
	public static void ecrireDans(final File fichier, final String ligne) throws IOException {
	FileWriter writer = null;
	try{
	     writer = new FileWriter(fichier, true);
	     writer.write(ligne);
	}catch (IOException ex){
	    ex.printStackTrace();
	}finally {
	  if(writer != null){
	     writer.close();
	  }
	}
	}
	
	
	public static void detruireFichier(File fichier) throws IOException {
		fichier.delete();
     }
}