package dessinPk;

import java.util.*;
import java.io.*;
import grapheX.*;

public class GrapheEdition extends GrapheHashMap {

  HashMap<String,Sommet> HSS;

  GrapheEdition() {
    HSS=new HashMap<String,Sommet>();
  }
  
  GrapheEdition(Scanner s, int l, char c) {
    HSS=new HashMap<String,Sommet>();
    charger(s,l,c);
    construire();
  }

  public Sommet retrouverSommet(String mot) {
    return HSS.get(mot);
  }

  public void ajouterSommet(Sommet u) {
    super.ajouterSommet(u);
    HSS.put(u.toString(),u);
  }

  public static int nombreDeDifferences(String u, String v) {
    if (u.length()!=v.length()) return -1;
    int err=0;
    for (int i=0;i<u.length();i++)
      if (u.charAt(i)!=v.charAt(i)) err++;
    return err;
  }
    
  public void charger(Scanner s, int l, char c) {
    while (s.hasNext()) {
      String mot=s.next();
      if (mot.length()==l && mot.indexOf(c)>=0 && !HSS.containsKey(mot)) {
        Sommet u=new Sommet(mot);
        ajouterSommet(u);
      }
    }
  }
  
  public void construire() {
    for (Sommet o:sommets())
      for (Sommet d:sommets())
        if (nombreDeDifferences(o.toString(),d.toString())==1)
          ajouterArc(o,d);
  }
  
  public  boolean isole(Sommet s) {
    return (voisins(s).isEmpty());
  }
  
  public GrapheEdition supprimerSommetsIsoles() {
    GrapheEdition g=new GrapheEdition();
    for (Sommet s:sommets())
      if (!isole(s)) {
        g.ajouterSommet(s);
      }
    g.construire();
    return g;
  }
  
  public static void main(String[] args) throws Exception{
// Ouverture du fichier 'mots.txt'
    Scanner fichier=new Scanner(new File("mots.txt")); 
// Selection des mots de 4 lettres contrnant un 'x'
    GrapheEdition g=new GrapheEdition(fichier,4,'x'); 
// Pour supprimer les sommets isoles, c'est-a-dire sans arcs
    g=g.supprimerSommetsIsoles();
// Creation d'un parcours
    Parcours p=new Parcours(g);
// Ouverture de la fenetre
    Dessin dessin = new Dessin(p,700,500); // plus grand : 1100 900
// Dessin du contenu de la fenetre
    dessin.redessine();
  }
  
}