package dessinPk;

import java.util.*;

import javax.swing.*;
import javax.swing.event.*;

import java.awt.*;
import java.awt.event.*;
import java.lang.reflect.InvocationTargetException;

import grapheX.*;

class PanneauCommande extends JPanel {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	Dessin dessin;
	PanneauCommande(Dessin c) {
		super();
		dessin=c;
		JButton bouton=new JButton("Re-ordonner");
		bouton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				dessin.FR(100);
				dessin.redessine();
			}
		}); 
		add(bouton);
		bouton=new JButton("Reset couleurs");
		bouton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				dessin.resetCouleurs();
				dessin.redessine();
			}

		});
		add(bouton);
		bouton=new JButton("Quitter");
		bouton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.exit(0);
			}
		}); 
		add(bouton);
	}
}

class PanneauDessin extends JComponent {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	Dessin dessin;

	PanneauDessin(Dessin c) {
		super();
		dessin=c;
		setOpaque(true);
		setBackground(Color.white);
	}

	public void paintComponent(Graphics g) {
		super.paintComponent(g);
		g.setColor(Color.white);
		g.fillRect(0,0,getWidth(),getHeight());
		g.setColor(Color.black);
		g.setFont(new Font("Default",Font.PLAIN,10));
		for(Sommet s:dessin.g.sommets()) {
			for ( Arc a : dessin.g.voisins(s) ) {
				PointG o=dessin.points.get(a.origine());
				PointG d=dessin.points.get(a.destination());
				g.setColor(dessin.couleur(a));
				g.drawLine(o.x*(getWidth()-40)/dessin.largeur+20,o.y*(getHeight()-40)/dessin.hauteur+20,d.x*(getWidth()-40)/dessin.largeur+20,d.y*(getHeight()-40)/dessin.hauteur+20);
			}
		}
		for(Sommet s:dessin.g.sommets()) {
			PointG p=dessin.points.get(s);
			g.setColor(dessin.couleur(s));
			g.fillOval(p.x*(getWidth()-40)/dessin.largeur-2+20,p.y*(getHeight()-40)/dessin.hauteur-2+20,4,4);
			g.drawString(s.toString(),p.x*(getWidth()-40)/dessin.largeur-5+20,
					p.y*(getHeight()-40)/dessin.hauteur-5+20);
		}
	}

}
