package grapheX;
//https://www.enseignement.polytechnique.fr/informatique/INF431/X05-2006-2007/TD/TD7/GrapheHashMap.java

import java.util.*;


public class GrapheHashMap extends Graphe {
  LinkedList<Sommet> listeSommets;
  HashMap<Sommet,HashMap<Sommet,Arc<Sommet>>> aretes;
  
  
 public  GrapheHashMap() {
    listeSommets = new LinkedList<Sommet>();
    aretes = new HashMap<Sommet,HashMap<Sommet,Arc<Sommet>>>();
  }
    
  public int taille() {
    return listeSommets.size();
  }
  
  public Graphe copie() {
    return null;
  }
  
  public void ajouterSommet(Sommet s) {
    listeSommets.add(s);
    aretes.put(s,new HashMap<Sommet,Arc<Sommet>>());
  }
  
  public boolean existeArc(Sommet s, Sommet t) {
    return aretes.get(s).containsKey(t);
  }
  
  public void ajouterArc(Sommet s, Sommet t) {
	  this.ajouterArc(s,t,0);
	  }
  
  @Override
  public void ajouterArc(Arc<Sommet> arc) {
	  HashMap<Sommet, Arc<Sommet>> s = aretes.get(arc.origine());
	  System.out.println("aretes : " + s + "pour " + arc);
	  s.put(arc.destination(), arc);
  	
  }
  public void ajouterArc(Sommet s, Sommet t, int val) {
	 Arc<Sommet> a = new Arc<Sommet>(s,t,val);
    aretes.get(s).put(t,a);
  }
  
  public int valeurArc(Sommet s, Sommet t) {
    if (!existeArc(s,t)) throw new Error("Arc inexistant");
    return aretes.get(s).get(t).valeur();
  }
  
  public void enleverArc(Sommet s, Sommet t) {
    if (!existeArc(s,t)) return ;
    aretes.get(s).remove(t);
  }
  
  public Collection<Sommet> sommets() {
    return listeSommets;
  }
  
  public Collection<Arc<Sommet>> voisins(Sommet s) {
    HashMap<Sommet, Arc<Sommet>> arcs = aretes.get(s);
    if ( arcs != null )
      return arcs.values();
    return Collections.emptySet();
  }



}