package grapheX;

import java.io.*;
import java.util.*;

/**
   Graphes implantes dans des "listes"

   @author FMorain (morain@lix.polytechnique.fr)
   @version 2007.01.30 [propagation modifs de Arc]
 */

public class GrapheListe extends Graphe{
  private Vector<LinkedList<Arc<Sommet>>> L;
  private Numerotation numerotation;

  public int taille(){
    return L.size();
  }
  
  private static void remplir(GrapheListe G, int n){
    G.numerotation = new Numerotation(n);
    G.L = new Vector<LinkedList<Arc<Sommet>>>(n);
    G.L.setSize(n);
    G.oriente = true; // defaut
  }

  // construction d un graphe vide a n sommets
  public GrapheListe(){
  }
  
  public GrapheListe(int n){
    remplir(this, n);
  }
  
  public GrapheListe(String str){
      remplirAvecScanner(this, new Scanner(str));
  }
  
  public void ajouterSommet(Sommet s){
    if(numerotation.ajouterElement(s))
      L.set(numerotation.numero(s), new LinkedList<Arc<Sommet>>());
  }

  public boolean existeArc(Sommet s, Sommet t){
    for(Arc<Sommet> a : L.get(numerotation.numero(s)))
      if((a.destination()).equals(t))
        return true;
    return false;
  }

  private boolean existeArc(int i, int j){
    Sommet t = numerotation.elementAt(j);
    for(Arc<Sommet> a : L.get(i))
      if(a.destination().equals(t))
        return true;
    return false;
  }

  public void ajouterArc(Sommet s, Sommet t, int val){
    ajouterSommet(s);
    ajouterSommet(t);
    int si = numerotation.numero(s);
    L.get(si).addLast(new Arc<Sommet>(s, t, val));
  }
  
  @Override
  public void ajouterArc(Arc<Sommet> arc) {
	  Sommet s = arc.origine();
	  ajouterSommet(s);
	  ajouterSommet(arc.destination());
	    int si = numerotation.numero(s);
	    L.get(si).addLast(arc);
	  }
  	
  

  public void ajouterArc(int i, int j, int val){
    L.get(i).addLast(new Arc<Sommet>(numerotation.elementAt(i),
        numerotation.elementAt(j), 
        val));
  }

  public int valeurArc(Sommet s, Sommet t){
    for(Arc<Sommet> a : L.get(numerotation.numero(s)))
      if(a.destination().equals(t))
        return a.valeur();
    return -1; // convention
  }

  public int valeurArc(int i, int j){
    Sommet t = numerotation.elementAt(j);
    for(Arc a : L.get(i))
      if(a.destination().equals(t))
        return a.valeur();
    return -1; // convention
  }

  public void enleverArc(Sommet s, Sommet t){
    int si = numerotation.numero(s);
    Arc<Sommet> a = null;
    for(Arc<Sommet> aa : L.get(numerotation.numero(s)))
      if(aa.destination().equals(t)){
        a = aa;
        break;
      }
    if(a != null)
      L.get(numerotation.numero(s)).remove(a);
  }

  public void modifierValeur(Sommet s, Sommet t, int val){
    for(Arc a : L.get(numerotation.numero(s)))
      if(a.destination().equals(t)){
        a.modifierValeur(val);
        return;
      }
  }

  public LinkedList<Arc<Sommet>> voisins(Sommet s){
    return L.get(numerotation.numero(s));
  }

  public Collection<Sommet> sommets(){
    return numerotation.elements();
  }

  public GrapheListe copie(){
    int n = taille();
    GrapheListe G = new GrapheListe(n);
    for(int i = 0; i < n; i++)
      G.ajouterSommet(numerotation.elementAt(i));
    for(int i = 0; i < n; i++){
      // recopie dans le meme ordre
      LinkedList<Arc<Sommet>> Li = G.L.get(i);
      for(Arc<Sommet> a : L.get(i))
        Li.addLast(a);
    }
    return G;
  }

  // retourne vrai si le caractere c est dans str
  private static boolean option(String str, char c){
    for(int i = 0; i < str.length(); i++)
      if(str.charAt(i) == c)
        return true;
    return false;
  }
  
  public static void remplirAvecScanner(GrapheListe G, Scanner scan){
    System.out.println(scan.next());
    int n = scan.nextInt();
    remplir(G, n);
    String str = scan.next();
    boolean estValue = option(str, 'v');
    boolean estSym = option(str, 's');
    boolean avecCouples = option(str, 'c');

    if(estSym)
      G.oriente = false;
    System.out.println("n = "+n);
    for(int i = 0; i < n; i++){
      Sommet s = new Sommet(scan.next());
      G.ajouterSommet(s);
    }
    if(avecCouples){
      System.out.println("Avec couples");
      // on lit des lignes "i j dij" ou "i j"
      while(scan.hasNext()){
        Sommet s = new Sommet(scan.next());
        Sommet t = new Sommet(scan.next());
        int si = G.numerotation.numero(s);
        int ti = G.numerotation.numero(t);
        if(estValue)
          G.ajouterArc(si, ti, (int)scan.nextInt());
        else
          G.ajouterArc(si, ti, 1);
      }
    }
    else{
      // format "s ns t0 t1 ... t{ns-1}"
      // ou     "s ns t0 v0 t1 v1 ... t{ns-1} v{ns-1}"
      System.out.println("Avec listes, estvalue="+estValue);
      for(int r = 0; r < n; r++){
        Sommet s = new Sommet(scan.next());
        int si = G.numerotation.numero(s);
        int nj = (int)scan.nextInt();
        for(int k = 0; k < nj; k++){
          Sommet t = new Sommet(scan.next());
          int ti = G.numerotation.numero(t);
          if(estValue)
            G.ajouterArc(si, ti,
                (int)scan.nextInt());
          else
            G.ajouterArc(si, ti, 1);
        }
      }
    }
    System.out.println("G="+G);
    if(estSym)
      // on doit symetriser G
      for(Sommet s : G.sommets())
        for(Sommet t : G.sommets())
          if(G.existeArc(s, t) 
              && !G.existeArc(t, s))
            G.ajouterArc(t, s, 
                G.valeurArc(s, t));
  }

  public static GrapheListe deFichier(String nomfic){
    try{
      Scanner scan = 
        new Scanner(
            new BufferedReader(new FileReader(nomfic)));
      GrapheListe G = new GrapheListe();
      remplirAvecScanner(G, scan);
      return G;
    }
    catch(Exception e) { }
    return null;
  }



}
