package grapheX;

import java.util.*;

/**
   Graphes implante's dans des "matrices"

   @author FMorain (morain@lix.polytechnique.fr)
   @version 2007.01.12
*/

public class GrapheMatrice extends Graphe{
    private Vector<Vector<Arc<Sommet>>> M;
    private Numerotation numerotation;

    public int taille(){
	return M.size();
    }

    public GrapheMatrice(int n){
	numerotation = new Numerotation(n);
	M = new Vector<Vector<Arc<Sommet>>>(n);
	M.setSize(n);
    }

    public void ajouterSommet(Sommet s){
	if(numerotation.ajouterElement(s)){
	    int n = taille();
	    Vector<Arc<Sommet>> vs = new Vector<Arc<Sommet>>(n);
	    vs.setSize(n);
	    M.set(numerotation.numero(s), vs);
	}
    }

    public boolean existeArc(Sommet s, Sommet t){
	int si = numerotation.numero(s);
	int ti = numerotation.numero(t);
	return M.get(si).get(ti) != null;
    }

    private boolean existeArc(int i, int j){
	return M.get(i).get(j) != null;
    }

    public void ajouterArc(Sommet s, Sommet t, int val){
	ajouterSommet(s);
	ajouterSommet(t);
	int si = numerotation.numero(s);
	int ti = numerotation.numero(t);
	M.get(si).set(ti, new Arc<Sommet>(s, t, val));
    }

    public int valeurArc(Sommet s, Sommet t){
	int si = numerotation.numero(s);
	int ti = numerotation.numero(t);
	return M.get(si).get(ti).valeur();
    }

    private int valeurArc(int i, int j){
	return M.get(i).get(j).valeur();
    }

    public void enleverArc(Sommet s, Sommet t){
        int si = numerotation.numero(s);
	int ti = numerotation.numero(t);
	M.get(si).remove(ti);
    }

    public void modifierValeur(Sommet s, Sommet t, int val){
        int si = numerotation.numero(s);
	int ti = numerotation.numero(t);
	M.get(si).get(ti).modifierValeur(val);
    }

    public LinkedList<Arc<Sommet>> voisins(Sommet s){
	LinkedList<Arc<Sommet>> l = new LinkedList<Arc<Sommet>>();
	int si = numerotation.numero(s);

	for(int j = 0; j < taille(); j++)
	    if(existeArc(si, j))
		l.addLast(M.get(si).get(j));
	return l;
    }

    public Collection<Sommet> sommets(){
	return numerotation.elements();
    }

    public GrapheMatrice copie(){
	int n = taille();
	GrapheMatrice G = new GrapheMatrice(n);
	for(int i = 0; i < n; i++)
	    G.ajouterSommet(numerotation.elementAt(i));
	for(int i = 0; i < n; i++)
	    for(int j = 0; j < n; j++)
		if(M.get(i).get(j) != null)
		    G.ajouterArc(numerotation.elementAt(i),
				 numerotation.elementAt(j),
				 valeurArc(i, j));
	return G;
    }

    public static GrapheMatrice deMatrice(int[][] M){
	int n = M.length;
	GrapheMatrice G = new GrapheMatrice(n);

	for(int i = 0; i < n; i++)
	    G.ajouterSommet(new Sommet(i+""));
	for(int i = 0; i < n; i++){
	    for(int j = 0; j < M[i].length; j++)
		if(M[i][j] == 1)
		    G.ajouterArc(G.numerotation.elementAt(i),
				 G.numerotation.elementAt(j), 
				 1);
	}
	return G;
    }

	@Override
	public void ajouterArc(Arc<Sommet> arc) {
		// TODO Auto-generated method stub
		
	}

}

