	
package grapheX;

import java.util.*;

public	class Parcours {
	  
	  final static int inexplore=0, explore=1, encours=2;
	  final static int INFINITY=-1;
	  
	  HashMap<Sommet,Integer> distances, nums, etats, couleurSommets;
	  HashMap<Arc,Integer> couleurArcs;
	  HashMap<Sommet,Arc> arcPeres;
	  
	  Graphe g;  
	  
	public  Parcours(Graphe g) {
	    this.g =g;
	    distances=new HashMap<Sommet,Integer>();
	    nums=new HashMap<Sommet,Integer>();
	    etats=new HashMap<Sommet,Integer>();
	    arcPeres=new HashMap<Sommet,Arc>();
	    couleurSommets=new HashMap<Sommet,Integer>();
	    couleurArcs=new HashMap<Arc,Integer>();
	  }
	  
	public  void initParcours() {
	    distances.clear();
	    nums.clear();
	    etats.clear();
	    arcPeres.clear();
	  }
	  
	  public  void initCouleurs() {
	    couleurSommets.clear();
	    couleurArcs.clear();
	  }
	  
	  public  int distance(Sommet s) {
	    if (distances.containsKey(s)) return distances.get(s);
	    else return INFINITY;
	  }
	  public  void distance(Sommet s,int d) {
	    distances.put(s,d);
	  }
	  
	 public int num(Sommet s) {
	    if (nums.containsKey(s)) return nums.get(s);
	    else return INFINITY;
	  }
	  void num(Sommet s,int n) {
	    nums.put(s,n);
	  }
	    
	 public int etat(Sommet s) {
	    if (etats.containsKey(s)) return etats.get(s);
	    else return inexplore;
	  }
	public  void etat(Sommet s, int e) {
	    etats.put(s,e);
	  }
	  
	 public  int couleur(Sommet s) {
	    if (couleurSommets.containsKey(s)) return couleurSommets.get(s);
	    else return 0;
	  }
	 public  void couleur(Sommet s, int c) {
	    couleurSommets.put(s,c);
	  }
	  
	 public  int couleur(Arc a) {
	    if (couleurArcs.containsKey(a)) return couleurArcs.get(a);
	    else return 0;
	  }
	 public  void couleur(Arc a, int c) {
	    couleurArcs.put(a,c);
	    // Symetrisation des couleurs pour les graphes non orientes
	    couleurArcs.put(new Arc(a.destination(),a.origine()),c);
	  }
	  
	  Arc arcPere(Sommet s) {
	    return arcPeres.get(s);
	  }
	  void arcPere(Sommet s, Arc p) {
	    arcPeres.put(s,p);
	  }

	public Graphe getGraphe() {
		// TODO Auto-generated method stub
		return g;
	}
	  
	}

