package dessinPk;

import grapheX.Arc;
import grapheX.Graphe;
import grapheX.Parcours;
import grapheX.Sommet;

import java.awt.Color;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Random;

import javax.swing.JFrame;

public class Dessin extends JFrame{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	static Color[] tabC={Color.black,Color.blue,Color.green,Color.orange,
		Color.red,Color.yellow,Color.pink,Color.gray,Color.lightGray,Color.magenta};

	Parcours p;
	Graphe g;
	HashMap<Sommet,PointG> points;
	HashMap<Sommet,Integer> couleurSommets;
	HashMap<Arc,Integer> couleurArcs;
	PanneauDessin panneau;

	int hauteur,largeur;  
	Random rnd;

	Dessin(Parcours p,int l, int h) {
		super("Dessin de graphe");
		setSize(l+40,h+90); // taille reelle qui peut ulterieurement etre modifiee
		// Initialisation du random identique pour tout le monde
		rnd=new Random(6);
		//
		points=new HashMap<Sommet,PointG>();
		this.g=p.getGraphe();
		this.p=p;
		hauteur=h; largeur=l; // taille virtuelle fixe (initialement egale a la taille relle)
		for(Sommet s:g.sommets()) {
			int x=(int) (largeur*rnd.nextDouble());
			int y=(int) (hauteur*rnd.nextDouble());
			points.put(s,new PointG(x,y));
		}
		//
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		panneau=new PanneauDessin(this);
		getContentPane().add(panneau);
		getContentPane().add("South",new PanneauCommande(this));
		setVisible(true);
	}

	Color couleur(Sommet s) {
		return tabC[p.couleur(s) % tabC.length];
	}

	Color couleur(Arc a) {
		return tabC[p.couleur(a) % tabC.length];
	}

	void resetCouleurs() {
		p.initCouleurs();
	}

	void redessine() {
		if (EventQueue.isDispatchThread())
			panneau.paintImmediately(0,0,panneau.getWidth(),panneau.getHeight());
		else {
			try {
				EventQueue.invokeAndWait(new Runnable() {
					public void run() {
						panneau.paintImmediately(0,0,panneau.getWidth(),panneau.getHeight());
					}
				});
			} catch (InterruptedException e) {
				throw new AssertionError(e);
			} catch (InvocationTargetException e) {
				throw new AssertionError(e);
			}
		}
	} 

	static double fa(double z,double k) {return z*z/k;}
	static double fr(double z,double k) {if (2*k>z) return k*k/z; else return 0;}

	void FR(int nbI) {
		for(Sommet s:g.sommets()) {
			PointG p=points.get(s);
			p.x=(int) (largeur*(0.5+rnd.nextDouble())/2);
			p.y=(int) (hauteur*(0.5+rnd.nextDouble())/2);
		}
		double aire=largeur*hauteur;
		int nbS=g.sommets().size();
		double k=Math.sqrt(aire/nbS);
		for (int i=0;i<nbI;i++) {
			HashMap<Sommet,Vecteur> dep=new HashMap<Sommet,Vecteur>();
			for (Sommet v:g.sommets()) {
				Vecteur dv=new Vecteur(0,0);
				for (Sommet u:g.sommets()) 
					if (u!=v) {
						PointG up=points.get(u);
						PointG vp=points.get(v);
						PointG D=new PointG(vp.x-up.x,vp.y-up.y);
						double norme=D.norme();
						double f=fr(norme,k)/norme;
						dv.x=dv.x+D.x*f;
						dv.y=dv.y+D.y*f;
					}
				for (Arc a:g.voisins(v)) {
					PointG vp=points.get(a.origine());
					PointG up=points.get(a.destination());
					PointG D=new PointG(vp.x-up.x,vp.y-up.y);
					double norme=D.norme();
					double f=fa(norme,k)/norme;
					dv.x=dv.x-D.x*f;
					dv.y=dv.y-D.y*f;
				}
				dep.put(v,dv);
			}
			double t=((double) largeur)/(10*(1+i));
			for (Sommet v:g.sommets()) {
				PointG pv=points.get(v);
				Vecteur dv=dep.get(v);
				double maxt=Math.min(1,t/dv.norme());
				pv.x=(int) (pv.x+dv.x*maxt);
				pv.y=(int) (pv.y+dv.y*maxt);
				pv.x=Math.min(largeur,Math.max(0,pv.x));
				pv.y=Math.min(hauteur,Math.max(0,pv.y));
				points.put(v,pv);
			}
		}
	}
}
class Vecteur {
	double x,y;
	Vecteur(double x,double y) {
		this.x=x; this.y=y;
	}
	double norme(){return Math.sqrt(x*x+y*y);}
}
class PointG {
	int x,y;
	PointG(int x, int y) {
		this.x=x;
		this.y=y;
	}
	double norme(){return Math.sqrt(x*x+y*y);}
	public String toString() {
		return "("+x+", "+y+")";
	}
}