package fr.unice.iut.gl;

import org.junit.Test;

import static org.junit.Assert.*;
import static org.mockito.Mockito.*;

public class DiceGameTest {

	@Test
	public void testIfLeftPlayerHasAHigherValueThenHeWins() throws DiceException {
		Player pLeft = mock(Player.class);
		when(pLeft.getValue()).thenReturn(6);
		
		Player pRight = mock(Player.class);
		when(pRight.getValue()).thenReturn(1);
		
		DiceGame diceGame = new DiceGame(pLeft, pRight);
		
		assertEquals("Le joueur gauche n'a pas gagn", pLeft, diceGame.launchGame());
		verify(pLeft, times(DiceGame.NUMBER_OF_TURN)).play();
		verify(pRight, times(DiceGame.NUMBER_OF_TURN)).play();
	}
	
	@Test
	public void testIfRightPlayerHasAHigherValueThenHeWins() throws DiceException {
		Player pLeft = mock(Player.class);
		when(pLeft.getValue()).thenReturn(1);
		Player pRight = mock(Player.class);
		when(pRight.getValue()).thenReturn(6);
		
		DiceGame diceGame = new DiceGame(pLeft, pRight);
		
		assertEquals("Le joueur droit n'a pas gagn", pRight, diceGame.launchGame());
		verify(pLeft, times(DiceGame.NUMBER_OF_TURN)).play();
		verify(pRight, times(DiceGame.NUMBER_OF_TURN)).play();
	}
	
	@Test
	public void testIfBothPlayerHaveTheSameValueNoOneWins() throws DiceException {
		Player pLeft = mock(Player.class);
		when(pLeft.getValue()).thenReturn(1);
		Player pRight = mock(Player.class);
		when(pRight.getValue()).thenReturn(1);
		
		DiceGame diceGame = new DiceGame(pLeft, pRight);
		
		assertEquals("Un des joueurs a gagn.", null, diceGame.launchGame());
		verify(pLeft, times(DiceGame.NUMBER_OF_TURN)).play();
		verify(pRight, times(DiceGame.NUMBER_OF_TURN)).play();
	}
}
