package fr.unice.iut.gl;

import java.util.Random;

public class Player {

	private String name;
	private Dice dice;
	private int lastValue;
	
	public Player(String name) {
		this(name, new Dice(6, new Random()));
	}
	
	public Player(String name, Dice dice) {
		this.name = name;
		this.lastValue = -1;
		this.dice = dice;
	}
	
	protected void play() throws DiceException {
		this.lastValue = this.dice.roll();
	}
	
	public int getValue() {
		return this.lastValue;
	}
}
