package fr.unice.iut.gl;

import static org.junit.Assert.*;

import java.util.Random;

import org.junit.Before;
import org.junit.Test;
import static org.mockito.Mockito.*;

public class DiceTest {

	private static int FACES = 6;
	private Dice dice;
	
	@Test
	public void testRollDiceReturnOneWhenRandomReturnZero() throws DiceException {
		Random noRandom = mock(Random.class);
		when(noRandom.nextInt(FACES)).thenReturn(0);
		
		this.dice = new Dice(FACES, noRandom);
		
		int obtainedNumber = this.dice.roll();
		assertEquals("La valeur retourne n'est pas 1",1, obtainedNumber);

		verify(noRandom).nextInt(FACES);
	}
	
	@Test
	public void testRollDiceReturnSixWhenRandomReturnFive() throws DiceException {
		Random noRandom = mock(Random.class);
		when(noRandom.nextInt(FACES)).thenReturn(5);
		
		this.dice = new Dice(FACES, noRandom);
		
		int obtainedNumber = this.dice.roll();
		assertEquals("La valeur retourne n'est pas 6",6, obtainedNumber);

		verify(noRandom).nextInt(FACES);
	}
	
	@Test(expected=DiceException.class)
	public void testRollDiceShouldReturnAnExceptionIfValueAboveNumberOfFaces() throws DiceException {
		Random noRandom = mock(Random.class);
		when(noRandom.nextInt(FACES)).thenReturn(6);
		
		this.dice = new Dice(FACES, noRandom);
		this.dice.roll();
	}
	
	@Test(expected=DiceException.class)
	public void testRollDiceShouldReturnAnExceptionIfRandomValueIsNegative() throws DiceException {
		Random noRandom = mock(Random.class);
		when(noRandom.nextInt(FACES)).thenReturn(-1);
		
		this.dice = new Dice(FACES, noRandom);
		this.dice.roll();
	}
}
