package fr.unice.iut.gl.service;

import fr.unice.iut.gl.core.User;
import fr.unice.iut.gl.core.UserNotFoundException;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import java.util.List;

/**
 * Created by urli on 25/01/2016.
 */

@Path("/user/")
public class UserService {

    @POST
    @Consumes(MediaType.APPLICATION_JSON)
    public Response createUserByName(User user) {
        User.addUser(user);
        return Response.ok().build();
    }

    @GET
    @Produces(MediaType.APPLICATION_JSON)
    public List<User> getAllUsers() {
        return User.allUsers();
    }

    @GET
    @Produces(MediaType.APPLICATION_JSON)
    @Path("{pseudo}")
    public Response getUser(@PathParam("pseudo") String pseudo) {
        try {
            User u = User.foundUserByPseudo(pseudo);
            return Response.ok(u).build();
        } catch (UserNotFoundException e) {
            return Response.status(404).entity(e.getMessage()).build();
        }

    }

    @PUT
    @Path("{pseudo}")
    public Response getUser(@PathParam("pseudo") String pseudo, String name) {
        try {
            User u = User.foundUserByPseudo(pseudo);
            u.setName(name);

            return Response.ok().build();
        } catch (UserNotFoundException e) {
            return Response.status(404).entity(e.getMessage()).build();
        }
    }

    @DELETE
    @Path("{pseudo}")
    public Response deleteUser(@PathParam("pseudo") String pseudo) {
        try {
            User u = User.foundUserByPseudo(pseudo);
            User.removeUser(u);
            return Response.ok().build();
        } catch (UserNotFoundException e) {
            return Response.status(404).entity(e.getMessage()).build();
        }
    }

    @GET
    @Path("/json/{pseudo}")
    public Response jsonFromUser(@PathParam("pseudo") String pseudo) {
        try {
            User u = User.foundUserByPseudo(pseudo);
            JSONObject json = new JSONObject();
            json.put("nom",u.getName());
            json.put("pseudonyme",u.getPseudo());

            return Response.ok(json).build();
        } catch (UserNotFoundException e) {
            return Response.status(404).entity(e.getMessage()).build();
        } catch (JSONException e) {
            return Response.status(500).entity(e.getMessage()).build();
        }
    }
}
