package fr.unice.iut.gl.core;

import javax.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by urli on 25/01/2016.
 */
@XmlRootElement
public class User {
    private static List<User> users = new ArrayList<User>();

    private String name;
    private String pseudo;

    public User() {}
    public User(String name, String pseudo) {
        this.name = name;
        this.pseudo = pseudo;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPseudo(String pseudo) { this.pseudo = pseudo; }

    public String getPseudo() {
        return this.pseudo;
    }

    public static User foundUserByPseudo(String pseudo) throws UserNotFoundException {
        for (User user : users) {
            if (user.getPseudo().equals(pseudo)) {
                return user;
            }
        }
        throw new UserNotFoundException("User "+pseudo+" cannot be found.");
    }

    public static void addUser(User u) {
        users.add(u);
    }

    public static List<User> allUsers() {
        return users;
    }

    public static void removeUser(User u) throws UserNotFoundException {
        if (users.contains(u)) {
            users.remove(u);
        } else
            throw new UserNotFoundException("User cannot be found.");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        User user = (User) o;

        if (name != null ? !name.equals(user.name) : user.name != null) return false;
        return pseudo != null ? pseudo.equals(user.pseudo) : user.pseudo == null;

    }

    @Override
    public int hashCode() {
        int result = name != null ? name.hashCode() : 0;
        result = 31 * result + (pseudo != null ? pseudo.hashCode() : 0);
        return result;
    }
}
