package fr.unice.iut.library.services;

import java.util.List;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

import fr.unice.iut.library.Book;
import fr.unice.iut.library.exception.BookAlreadyExistException;

@Path("/book")
public class BookService {

	@Path("/")
	@GET
	@Produces(MediaType.APPLICATION_JSON)
	public List<Book> getAllBooks() {
		return Book.getAllBooks();
	}
	
	@Path("/")
	@POST
	@Consumes(MediaType.APPLICATION_JSON)
	public Response createBook(String bookJSON) throws JSONException {
		JSONObject book = new JSONObject(bookJSON);
		String isbn = book.optString("isbn");
		String title = book.optString("title");
		try {
			Book.createBook(new Book(isbn,title));
			return Response.ok().build();
		} catch (BookAlreadyExistException e) {
			return Response.status(500).entity("This book already exist.").build();
		}
		
	}
	
	@Path("/{bookISBN}")
	@GET
	@Produces(MediaType.APPLICATION_JSON)
	public Response retrieveBook(@PathParam("bookISBN") String isbn) {
		Book b = Book.retrieveBookByISBN(isbn);
		if (b != null) {
			return Response.ok(b).build();
		} else {
			return Response.status(404).entity("There no book with this ISBN").build();
		}
	}
	
	@Path("/{bookISBN}")
	@DELETE
	@Produces(MediaType.APPLICATION_JSON)
	public Response deleteBook(@PathParam("bookISBN") String isbn) {
		Book b = Book.retrieveBookByISBN(isbn);
		if (b != null) {
			Book.deleteBook(b);
			return Response.ok().build();
		} else {
			return Response.status(404).entity("There no book with this ISBN").build();
		}
	}
}
