package fr.unice.iut.library;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

import fr.unice.iut.library.exception.BookAlreadyExistException;

@XmlRootElement
public class Book {
	
	private static Set<Book> allBooks = new HashSet<Book>();
	
	private String isbn;
	private String title;
	private String hiddenField;
	
	public Book(String isbn, String title) {
		super();
		this.isbn = isbn;
		this.title = title;
		this.hiddenField = Math.random()+"";
	}

	public String getIsbn() {
		return isbn;
	}

	public void setIsbn(String isbn) {
		this.isbn = isbn;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}
	
	@XmlTransient
	public String getHiddenField() {
		return hiddenField;
	}


	public void setHiddenField(String hiddenField) {
		this.hiddenField = hiddenField;
	}
	
	public static void createBook(Book b) throws BookAlreadyExistException {
		if (retrieveBookByISBN(b.getIsbn()) != null) {
			throw new BookAlreadyExistException();
		} else {
			allBooks.add(b);
		}
	}
	
	public static List<Book> getAllBooks() {
		return new ArrayList<Book>(allBooks);
	}
	
	public static void deleteBook(Book b) {
		allBooks.remove(b);
	}
	
	public static Book retrieveBookByISBN(String isbn) {
		for (Book b : allBooks) {
			if (b.getIsbn().equals(isbn)) {
				return b;
			}
		}
		return null;
	}
}
