package main;

import static org.junit.Assert.*;
import static org.mockito.Mockito.*;
import java.util.Random;

import org.junit.Before;
import org.junit.Test;

public class GameTest {
	
	private Game game;
	
	@Test
	public void testGameTurnMustIncrementTurnIfRolldiceNumberIsValid() throws Exception {
		
		Random mockRandom = mock(Random.class);
		when(mockRandom.nextInt(6)).thenReturn(5);
		
		this.game = new Game(mockRandom);
		game.gameTurn();
		assertEquals("Turn value is not 1", 1, game.getTurn());
	}
	
	@Test
	public void testGameTurnMustNotIncrementTurnIfRolldiceNumberIsNotValid() throws Exception {
		Random mockRandom = mock(Random.class);
		when(mockRandom.nextInt(6)).thenReturn(12);
		
		game = new Game(mockRandom);
		try {
			game.gameTurn();
			assertEquals("Turn value is not 1", 0, game.getTurn());
		} catch (Exception e) {}
	}
	
	@Test(expected=Exception.class)
	public void testGameMustThrowAnExceptionIfRolldiceNumberIsNotValid() throws Exception {
		Random mockRandom = mock(Random.class);
		when(mockRandom.nextInt(6)).thenReturn(12);
		
		game = new Game(mockRandom);
		game.gameTurn();
	}
}
